/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.counter;

import com.mojang.serialization.MapCodec;
import github.mrh0.buildersaddition2.blocks.base.AbstractStorageBlock;
import github.mrh0.buildersaddition2.blocks.counter.CounterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends AbstractStorageBlock {
    public static final MapCodec<CounterBlock> CODEC = CounterBlock.m_306223_(CounterBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_COUNTERTOP = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);

    public CounterBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private VoxelShape getShapeForDirection(Direction direction) {
        return Shapes.m_83110_((VoxelShape)SHAPE_COUNTERTOP, (VoxelShape)(switch (direction) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        }));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CounterBlockEntity(pos, state);
    }
}

