/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.chair;

import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.blocks.blockstate.PillowState;
import github.mrh0.buildersaddition2.blocks.chair.ChairBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import github.mrh0.buildersaddition2.common.variants.WoolVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ChairBlueprint
extends BlockBlueprint<WoodVariant, ChairBlock> {
    public ChairBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "chair";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Chair";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<ChairBlock> getBlock(WoodVariant variant) {
        return () -> new ChairBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.planks));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<ChairBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<ChairBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<ChairBlock> block, WoodVariant variant) {
        MultiPartBlockStateBuilder bs = provider.multipartHorizontalFacing(provider.getMultipartBuilder((Block)block.get()), this.model(this.getBlockModelPath(variant)), 180, false);
        for (int i = 0; i < WoolVariant.ALL.size(); ++i) {
            WoolVariant wool = WoolVariant.ALL.get(i);
            ((MultiPartBlockStateBuilder.PartBuilder)bs.part().modelFile(this.model("block/" + wool.getName() + "_stool_pillow")).addModel()).condition(ChairBlock.PILLOW, (Comparable[])new PillowState[]{PillowState.fromIndex(i)}).end();
        }
    }

    @Override
    public void buildLootTable(BPLootTableProvider provider, RegistryObject<ChairBlock> block, WoodVariant variant) {
        LootTable.Builder builder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ChairBlock)block.get()).m_5456_())).m_79080_(ExplosionCondition.m_81661_()));
        for (int i = 0; i < Index.PILLOW.getBlockCount(); ++i) {
            Block wool = Index.PILLOW.getBlock(i);
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)wool.m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(ChairBlock.PILLOW, (Comparable)((Object)PillowState.fromIndex(i))))));
        }
        provider.m_247577_((Block)block.get(), builder);
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 1;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped);
    }
}

