/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.chair;

import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.blocks.base.ISeatBlock;
import github.mrh0.buildersaddition2.blocks.blockstate.PillowState;
import github.mrh0.buildersaddition2.entity.seat.SeatEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChairBlock
extends Block
implements ISeatBlock {
    public static final EnumProperty<PillowState> PILLOW = EnumProperty.m_61587_((String)"pillow", PillowState.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_PILLOW = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    private static final VoxelShape SHAPE_BASE = Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ChairBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PILLOW, (Comparable)((Object)PillowState.NONE)));
        this.shapesCache = this.m_152458_(ChairBlock::buildShape);
    }

    private static VoxelShape getLegShape(int x, int z, boolean tall) {
        return Block.m_49796_((double)x, (double)0.0, (double)z, (double)((double)x + 2.0), (double)(tall ? 16.0 : 6.0), (double)((double)z + 2.0));
    }

    private static VoxelShape getBackShape(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> Block.m_49796_((double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)18.0, (double)14.0);
            case Direction.WEST -> Block.m_49796_((double)12.0, (double)12.0, (double)4.0, (double)14.0, (double)18.0, (double)12.0);
            case Direction.EAST -> Block.m_49796_((double)2.0, (double)12.0, (double)4.0, (double)4.0, (double)18.0, (double)12.0);
            default -> Block.m_49796_((double)4.0, (double)12.0, (double)2.0, (double)12.0, (double)18.0, (double)4.0);
        };
    }

    private static VoxelShape getLegsShape(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> Shapes.m_83124_((VoxelShape)ChairBlock.getLegShape(2, 2, false), (VoxelShape[])new VoxelShape[]{ChairBlock.getLegShape(12, 2, false), ChairBlock.getLegShape(2, 12, true), ChairBlock.getLegShape(12, 12, true)});
            case Direction.WEST -> Shapes.m_83124_((VoxelShape)ChairBlock.getLegShape(2, 2, false), (VoxelShape[])new VoxelShape[]{ChairBlock.getLegShape(12, 2, true), ChairBlock.getLegShape(2, 12, false), ChairBlock.getLegShape(12, 12, true)});
            case Direction.EAST -> Shapes.m_83124_((VoxelShape)ChairBlock.getLegShape(2, 2, true), (VoxelShape[])new VoxelShape[]{ChairBlock.getLegShape(12, 2, false), ChairBlock.getLegShape(2, 12, true), ChairBlock.getLegShape(12, 12, false)});
            default -> Shapes.m_83124_((VoxelShape)ChairBlock.getLegShape(2, 2, true), (VoxelShape[])new VoxelShape[]{ChairBlock.getLegShape(12, 2, true), ChairBlock.getLegShape(2, 12, false), ChairBlock.getLegShape(12, 12, false)});
        };
    }

    private static VoxelShape buildShape(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_(PILLOW) == PillowState.NONE) {
            return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{ChairBlock.getBackShape(dir), ChairBlock.getLegsShape(dir)});
        }
        return Shapes.m_83124_((VoxelShape)SHAPE_PILLOW, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, ChairBlock.getBackShape(dir), ChairBlock.getLegsShape(dir)});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext col) {
        return this.shapesCache.get(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PILLOW});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(c.m_7078_() ? c.m_8125_() : c.m_8125_().m_122424_()));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean type;
        boolean bl = type = state.m_61143_(PILLOW) == PillowState.NONE;
        if (type) {
            Item item = player.m_21120_(hand).m_41720_();
            for (int i = 0; i < Index.PILLOW.getBlockCount(); ++i) {
                if (item != Index.PILLOW.getBlock(i).m_5456_()) continue;
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_(PILLOW, (Comparable)((Object)PillowState.fromIndex(i))));
                world.m_5594_(player, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        return SeatEntity.createSeat(world, pos, (LivingEntity)player, type ? 0.3875 : 0.45, type ? SoundEvents.f_12634_ : SoundEvents.f_12641_);
    }
}

