/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.carpenters_table;

import github.mrh0.buildersaddition2.BA2;
import github.mrh0.buildersaddition2.blocks.carpenters_table.CarpenterTableMenu;
import github.mrh0.buildersaddition2.recipe.carpenter.CarpenterRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CarpenterTableScreen
extends AbstractContainerScreen<CarpenterTableMenu> {
    private static final ResourceLocation BG_LOCATION = BA2.get("textures/gui/container/carpenter_table.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public CarpenterTableScreen(CarpenterTableMenu menu, Inventory p_99311_, Component p_99312_) {
        super((AbstractContainerMenu)menu, p_99311_, p_99312_);
        menu.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics gg, int x, int y, float partial) {
        super.m_88315_(gg, x, y, partial);
        this.m_280072_(gg, x, y);
    }

    protected void m_7286_(GuiGraphics gg, float partial, int x, int y) {
        this.m_293900_(gg);
        int i = this.f_97735_;
        int j = this.f_97736_;
        gg.m_280218_(BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        gg.m_280218_(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(gg, x, y, l, i1, j1);
        this.renderRecipes(gg, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics gg, int x, int y) {
        super.m_280072_(gg, x, y);
        if (!this.displayRecipes) {
            return;
        }
        int i = this.f_97735_ + 52;
        int j = this.f_97736_ + 14;
        int k = this.startIndex + 12;
        List<RecipeHolder<CarpenterRecipe>> list = ((CarpenterTableMenu)this.f_97732_).getRecipes();
        for (int l = this.startIndex; l < k && l < ((CarpenterTableMenu)this.f_97732_).getNumRecipes(); ++l) {
            int i1 = l - this.startIndex;
            int j1 = i + i1 % 4 * 16;
            int k1 = j + i1 / 4 * 18 + 2;
            if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
            gg.m_280153_(this.f_96547_, ((CarpenterRecipe)list.get(l).f_291008_()).m_8043_(this.f_96541_.f_91073_.m_9598_()), x, y);
        }
    }

    private void renderButtons(GuiGraphics gg, int p_282136_, int p_282147_, int p_281987_, int p_281276_, int p_282688_) {
        if (!this.displayRecipes) {
            return;
        }
        for (int i = this.startIndex; i < p_282688_ && i < ((CarpenterTableMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_281987_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_281276_ + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((CarpenterTableMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (p_282136_ >= k && p_282147_ >= i1 && p_282136_ < k + 16 && p_282147_ < i1 + 18) {
                j1 += 36;
            }
            gg.m_280218_(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics gg, int p_282658_, int p_282563_, int p_283352_) {
        if (!this.displayRecipes) {
            return;
        }
        List<RecipeHolder<CarpenterRecipe>> list = ((CarpenterTableMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < p_283352_ && i < ((CarpenterTableMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_282658_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_282563_ + l * 18 + 2;
            gg.m_280480_(((CarpenterRecipe)list.get(i).f_291008_()).m_8043_(this.f_96541_.f_91073_.m_9598_()), k, i1);
        }
    }

    public boolean m_6375_(double x, double y, int p_99320_) {
        this.scrolling = false;
        if (!this.displayRecipes) {
            return super.m_6375_(x, y, p_99320_);
        }
        int i = this.f_97735_ + 52;
        int j = this.f_97736_ + 14;
        int k = this.startIndex + 12;
        for (int l = this.startIndex; l < k; ++l) {
            int i1 = l - this.startIndex;
            double d0 = x - (double)(i + i1 % 4 * 16);
            double d1 = y - (double)(j + i1 / 4 * 18);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((CarpenterTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            this.f_96541_.f_91072_.m_105208_(((CarpenterTableMenu)this.f_97732_).f_38840_, l);
            return true;
        }
        i = this.f_97735_ + 119;
        j = this.f_97736_ + 9;
        if (x >= (double)i && x < (double)(i + 12) && y >= (double)j && y < (double)(j + 54)) {
            this.scrolling = true;
        }
        return super.m_6375_(x, y, p_99320_);
    }

    public boolean m_7979_(double x1, double y1, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)y1 - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(x1, y1, p_99324_, p_99325_, p_99326_);
    }

    public boolean mouseScrolled(double p_99314_, double p_99315_, double p_99316_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)p_99316_ / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((CarpenterTableMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((CarpenterTableMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((CarpenterTableMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

