/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.carpenters_table;

import com.google.common.collect.Lists;
import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.recipe.carpenter.CarpenterRecipe;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CarpenterTableMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 4;
    private static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<RecipeHolder<CarpenterRecipe>> recipes = Lists.newArrayList();
    private List<ItemStack> inputCache = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    long lastSoundTime;
    final List<Slot> inputSlots;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final SimpleContainer inputContainer = new SimpleContainer(4){

        public void m_6596_() {
            super.m_6596_();
            CarpenterTableMenu.this.slotsChanged(this);
            CarpenterTableMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public CarpenterTableMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, (Component)Component.m_237119_());
    }

    public CarpenterTableMenu(int id, Inventory inv, Component component) {
        super((MenuType)Index.CARPENTER_TABLE_MENU.get(), id);
        this.level = inv.f_35978_.m_9236_();
        this.inputSlots = List.of(this.m_38897_(new Slot((Container)this.inputContainer, 0, 11, 24)), this.m_38897_(new Slot((Container)this.inputContainer, 1, 29, 24)), this.m_38897_(new Slot((Container)this.inputContainer, 2, 11, 42)), this.m_38897_(new Slot((Container)this.inputContainer, 3, 29, 42)));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (CarpenterTableMenu.this.selectedRecipeIndex.m_6501_() < 0) {
                    CarpenterTableMenu.this.setupResultSlot();
                    return;
                }
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                CarpenterTableMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ((CarpenterRecipe)CarpenterTableMenu.this.recipes.get(CarpenterTableMenu.this.selectedRecipeIndex.m_6501_()).f_291008_()).m_7527_().forEach(ingredient -> {
                    for (Slot slot : CarpenterTableMenu.this.inputSlots) {
                        ItemStack itemstack;
                        if (!ingredient.test(slot.m_7993_()) || (itemstack = slot.m_6201_(1)).m_41619_()) continue;
                        CarpenterTableMenu.this.setupResultSlot();
                        break;
                    }
                });
                long l = CarpenterTableMenu.this.level.m_46467_();
                if (CarpenterTableMenu.this.lastSoundTime != l) {
                    CarpenterTableMenu.this.level.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    CarpenterTableMenu.this.lastSoundTime = l;
                }
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return CarpenterTableMenu.this.inputSlots.stream().map(Slot::m_7993_).toList();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<RecipeHolder<CarpenterRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlots.stream().anyMatch(Slot::m_6657_) && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public boolean m_6366_(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    public void slotsChanged(SimpleContainer container) {
        boolean changed = false;
        for (int i = 0; i < this.inputSlots.size(); ++i) {
            ItemStack itemstack = this.inputSlots.get(i).m_7993_();
            if (itemstack.m_150930_(this.inputCache.get(i).m_41720_())) continue;
            this.inputCache.set(i, itemstack.m_41777_());
            changed = true;
        }
        if (changed) {
            this.setupRecipeList(container);
        }
    }

    private void setupRecipeList(SimpleContainer container) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        this.recipes = this.level.m_7465_().m_44056_((RecipeType)CarpenterRecipe.Type.INSTANCE, (Container)container, this.level);
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            RecipeHolder<CarpenterRecipe> recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack itemstack = ((CarpenterRecipe)recipe.f_291008_()).assemble(this.inputContainer, this.level.m_9598_());
            this.resultContainer.m_40156_(recipe);
            this.resultSlot.m_5852_(itemstack.m_41777_());
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)Index.CARPENTER_TABLE_MENU.get();
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int slotFrom) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotFrom);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstackFrom = slot.m_7993_();
            Item item = itemstackFrom.m_41720_();
            itemstack = itemstackFrom.m_41777_();
            if (slotFrom == 4) {
                item.m_7836_(itemstackFrom, player.m_9236_(), player);
                if (!this.m_38903_(itemstackFrom, 5, 41, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstackFrom, itemstack);
            } else if (slotFrom >= 0 && slotFrom < 4 ? !this.m_38903_(itemstackFrom, 5, 41, false) : (slotFrom >= 5 && slotFrom < 32 ? this.m_38903_(itemstackFrom, 0, 4, false) || this.m_38903_(itemstackFrom, 32, 41, false) : slotFrom >= 32 && slotFrom < 41 && (this.m_38903_(itemstackFrom, 0, 4, false) || this.m_38903_(itemstackFrom, 5, 32, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstackFrom.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstackFrom.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstackFrom);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.m_150411_(player, (Container)this.inputContainer);
    }
}

