/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.bookshelf;

import github.mrh0.buildersaddition2.blocks.bookshelf.BookshelfBlock;
import github.mrh0.buildersaddition2.blocks.chair.ChairBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.RegistryObject;

public class BookshelfBlueprint
extends BlockBlueprint<WoodVariant, BookshelfBlock> {
    public BookshelfBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "bookshelf";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Bookshelf";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<BookshelfBlock> getBlock(WoodVariant variant) {
        return () -> new BookshelfBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.planks));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<BookshelfBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<BookshelfBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<BookshelfBlock> block, WoodVariant variant) {
        MultiPartBlockStateBuilder bs = provider.multipartHorizontalFacing(provider.getMultipartBuilder((Block)block.get()), this.model(this.getBlockModelPath(variant)), 180, false);
        for (int i = 0; i < BookshelfBlock.BOOKS.length; ++i) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)bs.part().modelFile(this.model("block/books_" + i)).rotationY(provider.getAngleFromDir(Direction.NORTH, 180)).uvLock(false).addModel()).condition((Property)ChairBlock.FACING, (Comparable[])new Direction[]{Direction.NORTH}).condition((Property)BookshelfBlock.BOOKS[i], (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model("block/books_" + i)).rotationY(provider.getAngleFromDir(Direction.EAST, 180)).uvLock(false).addModel()).condition((Property)ChairBlock.FACING, (Comparable[])new Direction[]{Direction.EAST}).condition((Property)BookshelfBlock.BOOKS[i], (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model("block/books_" + i)).rotationY(provider.getAngleFromDir(Direction.SOUTH, 180)).uvLock(false).addModel()).condition((Property)ChairBlock.FACING, (Comparable[])new Direction[]{Direction.SOUTH}).condition((Property)BookshelfBlock.BOOKS[i], (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model("block/books_" + i)).rotationY(provider.getAngleFromDir(Direction.WEST, 180)).uvLock(false).addModel()).condition((Property)ChairBlock.FACING, (Comparable[])new Direction[]{Direction.WEST}).condition((Property)BookshelfBlock.BOOKS[i], (Comparable[])new Boolean[]{true}).end();
        }
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.planks, variant.slab);
    }
}

