/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.bookshelf;

import com.mojang.serialization.MapCodec;
import github.mrh0.buildersaddition2.blocks.base.AbstractStorageBlock;
import github.mrh0.buildersaddition2.blocks.base.AbstractStorageBlockEntity;
import github.mrh0.buildersaddition2.blocks.bookshelf.BookshelfBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeServerPlayer;
import org.jetbrains.annotations.Nullable;

public class BookshelfBlock
extends AbstractStorageBlock {
    public static final MapCodec<BookshelfBlock> CODEC = BookshelfBlock.m_306223_(BookshelfBlock::new);
    public static final BooleanProperty BOOK0 = BooleanProperty.m_61465_((String)"book0");
    public static final BooleanProperty BOOK1 = BooleanProperty.m_61465_((String)"book1");
    public static final BooleanProperty BOOK2 = BooleanProperty.m_61465_((String)"book2");
    public static final BooleanProperty BOOK3 = BooleanProperty.m_61465_((String)"book3");
    public static final BooleanProperty BOOK4 = BooleanProperty.m_61465_((String)"book4");
    public static final BooleanProperty BOOK5 = BooleanProperty.m_61465_((String)"book5");
    public static final BooleanProperty BOOK6 = BooleanProperty.m_61465_((String)"book6");
    public static final BooleanProperty BOOK7 = BooleanProperty.m_61465_((String)"book7");
    public static final BooleanProperty[] BOOKS = new BooleanProperty[]{BOOK0, BOOK1, BOOK2, BOOK3, BOOK4, BOOK5, BOOK6, BOOK7};
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);

    public BookshelfBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BOOK0, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK5, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK6, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOOK7, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BOOK0, BOOK1, BOOK2, BOOK3, BOOK4, BOOK5, BOOK6, BOOK7});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BookshelfBlockEntity(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractStorageBlockEntity) {
            AbstractStorageBlockEntity be = (AbstractStorageBlockEntity)blockEntity;
            if (!(player instanceof IForgeServerPlayer)) {
                return InteractionResult.SUCCESS;
            }
            IForgeServerPlayer fsp = (IForgeServerPlayer)player;
            fsp.openMenu((MenuProvider)be, extraData -> extraData.m_130064_(pos));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    private VoxelShape getShapeForDirection(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return Math.min((float)this.getBookSum(state, level, pos) / 3.0f, 6.0f);
    }

    public static BlockState getState(BlockState state, boolean b1, boolean b2, boolean b3, boolean b4, boolean b5, boolean b6, boolean b7, boolean b8) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BOOK0, (Comparable)Boolean.valueOf(b1))).m_61124_((Property)BOOK1, (Comparable)Boolean.valueOf(b2))).m_61124_((Property)BOOK2, (Comparable)Boolean.valueOf(b3))).m_61124_((Property)BOOK3, (Comparable)Boolean.valueOf(b4))).m_61124_((Property)BOOK4, (Comparable)Boolean.valueOf(b5))).m_61124_((Property)BOOK5, (Comparable)Boolean.valueOf(b6))).m_61124_((Property)BOOK6, (Comparable)Boolean.valueOf(b7))).m_61124_((Property)BOOK7, (Comparable)Boolean.valueOf(b8));
    }

    public int getBookSum(BlockState state, LevelReader level, BlockPos pos) {
        int sum = 0;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BookshelfBlockEntity) {
            BookshelfBlockEntity be = (BookshelfBlockEntity)blockEntity;
            for (int i = 0; i < be.m_7086_().size(); ++i) {
                if (((ItemStack)be.m_7086_().get(i)).m_41613_() <= 0) continue;
                ++sum;
            }
        }
        return sum;
    }
}

