/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.blockstate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public enum ShopSignState implements StringRepresentable
{
    UP_X("up_x"),
    UP_Z("up_z"),
    DOWN_X("down_x"),
    DOWN_Z("down_z"),
    NORTH("north"),
    EAST("east"),
    SOUTH("south"),
    WEST("west");

    private final String name;

    private ShopSignState(String name) {
        this.name = name;
    }

    public static ShopSignState getFor(Direction face, Direction facing, BlockPos pos, Level world) {
        Block b = world.m_8055_(pos.m_121945_(face.m_122424_())).m_60734_();
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST -> ShopSignState.getForBlock(face, b);
            case Direction.UP -> {
                if (facing.m_122434_() == Direction.Axis.X) {
                    yield UP_X;
                }
                yield UP_Z;
            }
            case Direction.DOWN -> facing.m_122434_() == Direction.Axis.X ? DOWN_X : DOWN_Z;
        };
    }

    private static ShopSignState getForBlock(Direction d, Block b) {
        return switch (d) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public Direction.Axis getAxis() {
        if (this == EAST || this == WEST || this == UP_X || this == DOWN_X) {
            return Direction.Axis.X;
        }
        return Direction.Axis.Z;
    }

    public boolean isHorizontal() {
        return this != UP_X && this != UP_Z && this != DOWN_X && this != DOWN_Z;
    }

    public int toYRot() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP_X, DOWN_X -> 90;
            case UP_Z, DOWN_Z -> 0;
            case NORTH -> (int)Direction.NORTH.m_122435_();
            case EAST -> (int)Direction.EAST.m_122435_();
            case SOUTH -> (int)Direction.SOUTH.m_122435_();
            case WEST -> (int)Direction.WEST.m_122435_();
        };
    }

    public int toXRot() {
        return switch (this) {
            case UP_X, UP_Z -> 180;
            default -> 0;
        };
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }
}

