/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.blockstate;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum PanelState implements StringRepresentable
{
    NORTH("north", Direction.NORTH),
    WEST("west", Direction.WEST),
    EAST("east", Direction.EAST),
    SOUTH("south", Direction.SOUTH),
    DOUBLE_X("double_x", Direction.EAST),
    DOUBLE_Z("double_z", Direction.NORTH);

    private final String name;
    private final Direction facing;

    private PanelState(String name, Direction facing) {
        this.name = name;
        this.facing = facing;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public String toString() {
        return this.name;
    }

    public boolean isDouble() {
        return this == DOUBLE_X || this == DOUBLE_Z;
    }

    public PanelState getStateFromDirection(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> SOUTH;
        };
    }

    public static PanelState forFacings(Direction clickedSide, Direction entityFacing) {
        if (clickedSide == Direction.UP || clickedSide == Direction.DOWN) {
            if (entityFacing == Direction.NORTH) {
                return NORTH;
            }
            if (entityFacing == Direction.EAST) {
                return EAST;
            }
            if (entityFacing == Direction.SOUTH) {
                return SOUTH;
            }
            if (entityFacing == Direction.WEST) {
                return WEST;
            }
        }
        if (clickedSide == Direction.NORTH) {
            return SOUTH;
        }
        if (clickedSide == Direction.EAST) {
            return WEST;
        }
        if (clickedSide == Direction.SOUTH) {
            return NORTH;
        }
        if (clickedSide == Direction.WEST) {
            return EAST;
        }
        return NORTH;
    }

    public String m_7912_() {
        return this.name;
    }

    public static PanelState reverseFacing(Direction facing, boolean doub) {
        if (doub) {
            return facing.m_122434_() == Direction.Axis.X ? DOUBLE_X : DOUBLE_Z;
        }
        return switch (facing) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public float toYRot() {
        return switch (this) {
            case EAST -> Direction.EAST.m_122435_();
            case SOUTH -> Direction.SOUTH.m_122435_();
            case WEST -> Direction.WEST.m_122435_();
            default -> Direction.NORTH.m_122435_();
        };
    }
}

