/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.bench;

import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.blocks.bench.BenchBlock;
import github.mrh0.buildersaddition2.blocks.blockstate.BenchState;
import github.mrh0.buildersaddition2.blocks.blockstate.PillowState;
import github.mrh0.buildersaddition2.blocks.stool.StoolBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import github.mrh0.buildersaddition2.common.variants.WoolVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.RegistryObject;

public class BenchBlueprint
extends BlockBlueprint<WoodVariant, BenchBlock> {
    public BenchBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    protected Supplier<BenchBlock> getBlock(WoodVariant variant) {
        return () -> new BenchBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50705_));
    }

    @Override
    public String getBaseName() {
        return "bench";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Bench";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    public void buildLootTable(BPLootTableProvider provider, RegistryObject<BenchBlock> block, WoodVariant variant) {
        LootTable.Builder builder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((BenchBlock)block.get()).m_5456_())).m_79080_(ExplosionCondition.m_81661_()));
        for (int i = 0; i < Index.PILLOW.getBlockCount(); ++i) {
            Block wool = Index.PILLOW.getBlock(i);
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)wool.m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(StoolBlock.PILLOW, (Comparable)((Object)PillowState.fromIndex(i))))));
        }
        provider.m_247577_((Block)block.get(), builder);
    }

    @Override
    protected void buildBlockState(BPBlockStateProvider bsp, RegistryObject<BenchBlock> block, WoodVariant variant) {
        boolean uvLock = true;
        int offset = 90;
        ModelFile base = this.model(this.getBlockModelPath(variant));
        ModelFile legs = this.model(this.getBlockModelPath(variant, "_legs"));
        MultiPartBlockStateBuilder bs = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)bsp.getMultipartBuilder((Block)block.get()).part().modelFile(base).rotationY(0).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_X}).end().part().modelFile(base).rotationY(0).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.NONE_X}).end().part().modelFile(base).rotationY(90).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_Z}).end().part().modelFile(base).rotationY(90).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.NONE_Z}).end().part().modelFile(base).rotationY(90).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.NORTH}).end().part().modelFile(base).rotationY(90).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.SOUTH}).end().part().modelFile(base).rotationY(0).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.EAST}).end().part().modelFile(base).rotationY(0).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.WEST}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.NORTH, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.NORTH}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.EAST, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.EAST}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.SOUTH, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.SOUTH}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.WEST, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.WEST}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.NORTH, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_Z}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.SOUTH, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_Z}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.EAST, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_X}).end().part().modelFile(legs).rotationY(bsp.getAngleFromDir(Direction.WEST, offset)).uvLock(uvLock).addModel()).condition(BenchBlock.SHAPE, (Comparable[])new BenchState[]{BenchState.BOTH_X}).end();
        for (int i = 0; i < WoolVariant.ALL.size(); ++i) {
            WoolVariant wool = WoolVariant.ALL.get(i);
            ((MultiPartBlockStateBuilder.PartBuilder)bs.part().modelFile(this.model("block/" + wool.getName() + "_stool_pillow")).addModel()).condition(BenchBlock.PILLOW, (Comparable[])new PillowState[]{PillowState.fromIndex(i)}).end();
        }
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<BenchBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_legs"), this.resource("block/base_" + this.getBaseName() + "_legs")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.textureStripped);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<BenchBlock> block, WoodVariant variant) {
        ((ItemModelBuilder)provider.withParent(this.getRegistryName(variant), this.resource("block/base_" + this.getBaseName() + "_inventory")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped);
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 3;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped, variant.planks);
    }
}

