/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.bench;

import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.blocks.base.ISeatBlock;
import github.mrh0.buildersaddition2.blocks.blockstate.BenchState;
import github.mrh0.buildersaddition2.blocks.blockstate.PillowState;
import github.mrh0.buildersaddition2.entity.seat.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BenchBlock
extends Block
implements ISeatBlock {
    public static final EnumProperty<PillowState> PILLOW = EnumProperty.m_61587_((String)"pillow", PillowState.class);
    public static final EnumProperty<BenchState> SHAPE = EnumProperty.m_61587_((String)"shape", BenchState.class);
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)7.0, (double)3.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)7.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)3.0, (double)7.0, (double)13.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)7.0, (double)13.0);

    public BenchBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PILLOW, (Comparable)((Object)PillowState.NONE)));
    }

    public VoxelShape getShape(BlockState state) {
        VoxelShape shape;
        BenchState bs = (BenchState)((Object)state.m_61143_(SHAPE));
        VoxelShape voxelShape = shape = bs.getAxis() == Direction.Axis.Z ? SHAPE_Z : SHAPE_X;
        if (bs.hasLegNorth()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (bs.hasLegWest()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (bs.hasLegSouth()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (bs.hasLegEast()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, PILLOW});
    }

    public boolean isBench(BlockState state) {
        return state.m_60734_() instanceof BenchBlock;
    }

    public boolean connects(Direction.Axis current, BlockGetter worldIn, BlockPos pos, Direction dir) {
        BlockState state = worldIn.m_8055_(pos.m_121945_(dir));
        if (this.isBench(state)) {
            return ((BenchState)((Object)state.m_61143_(SHAPE))).getAxis() == current;
        }
        return false;
    }

    public BlockState getState(Direction.Axis current, BlockGetter worldIn, BlockPos pos, PillowState pillow) {
        BlockState out = (BlockState)this.m_49966_().m_61124_(PILLOW, (Comparable)((Object)pillow));
        if (current == Direction.Axis.Z) {
            boolean n = this.connects(current, worldIn, pos, Direction.NORTH);
            boolean s = this.connects(current, worldIn, pos, Direction.SOUTH);
            if (n && !s) {
                return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.NORTH));
            }
            if (!n && s) {
                return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.SOUTH));
            }
            if (n) {
                return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.NONE_Z));
            }
            return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.BOTH_Z));
        }
        boolean w = this.connects(current, worldIn, pos, Direction.WEST);
        boolean e = this.connects(current, worldIn, pos, Direction.EAST);
        if (e && !w) {
            return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.EAST));
        }
        if (!e && w) {
            return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.WEST));
        }
        if (e) {
            return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.NONE_X));
        }
        return (BlockState)out.m_61124_(SHAPE, (Comparable)((Object)BenchState.BOTH_X));
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return this.getState(c.m_8125_().m_122427_().m_122434_(), (BlockGetter)c.m_43725_(), c.m_8083_(), PillowState.NONE);
    }

    public BlockState m_7417_(BlockState stateIn, Direction p_60542_, BlockState p_60543_, LevelAccessor worldIn, BlockPos pos, BlockPos otherPos) {
        return this.getState(((BenchState)((Object)stateIn.m_61143_(SHAPE))).getAxis(), (BlockGetter)worldIn, pos, (PillowState)((Object)stateIn.m_61143_(PILLOW)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean type;
        boolean bl = type = state.m_61143_(PILLOW) == PillowState.NONE;
        if (type) {
            Item item = player.m_21120_(hand).m_41720_();
            for (int i = 0; i < Index.PILLOW.getBlockCount(); ++i) {
                if (item != Index.PILLOW.getBlock(i).m_5456_()) continue;
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_(PILLOW, (Comparable)((Object)PillowState.fromIndex(i))));
                world.m_5594_(player, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        return SeatEntity.createSeat(world, pos, (LivingEntity)player, type ? 0.3875 : 0.45, type ? SoundEvents.f_12634_ : SoundEvents.f_12641_);
    }
}

