/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.base;

import github.mrh0.buildersaddition2.blocks.base.IComparatorOverride;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractStorageBlockEntity
extends RandomizableContainerBlockEntity
implements IComparatorOverride {
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandlerModifiable> storageHandler;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            AbstractStorageBlockEntity.this.playSound(state, SoundEvents.f_11725_);
            AbstractStorageBlockEntity.this.onOpenClose(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            AbstractStorageBlockEntity.this.playSound(state, SoundEvents.f_11724_);
            AbstractStorageBlockEntity.this.onOpenClose(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int a, int b) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu menu = (ChestMenu)abstractContainerMenu;
                return menu.m_39261_() == AbstractStorageBlockEntity.this;
            }
            return false;
        }
    };

    public AbstractStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getRows();

    protected abstract void playSound(BlockState var1, SoundEvent var2);

    protected final void playDefaultSound(SoundEvent evt, Vec3i vector3i) {
        double d0 = (double)this.m_58899_().m_123341_() + 0.5 + (double)vector3i.m_123341_() / 2.0;
        double d1 = (double)this.m_58899_().m_123342_() + 0.5 + (double)vector3i.m_123342_() / 2.0;
        double d2 = (double)this.m_58899_().m_123343_() + 0.5 + (double)vector3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, evt, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    public void m_6520_(NonNullList<ItemStack> items) {
        this.inventory = items;
    }

    public int m_6643_() {
        return this.getRows() * 9;
    }

    protected IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this);
    }

    private static MenuType<ChestMenu> getMenuType(int rows) {
        return switch (rows) {
            case 1 -> MenuType.f_39957_;
            case 2 -> MenuType.f_39958_;
            case 4 -> MenuType.f_39960_;
            case 5 -> MenuType.f_39961_;
            case 6 -> MenuType.f_39962_;
            default -> MenuType.f_39959_;
        };
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inv) {
        return new ChestMenu(AbstractStorageBlockEntity.getMenuType(this.getRows()), id, inv, (Container)this, this.getRows());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_307714_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        if (!this.m_306148_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
        super.m_183515_(nbt);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        if (this.storageHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.storageHandler;
            this.storageHandler = null;
            oldHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && this.allowIO()) {
            if (this.storageHandler == null) {
                this.storageHandler = LazyOptional.of(this::createHandler);
            }
            return this.storageHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.storageHandler != null) {
            this.storageHandler.invalidate();
            this.storageHandler = null;
        }
    }

    protected void onOpenClose(BlockState state, boolean open) {
    }

    public void m_6596_() {
        super.m_6596_();
        this.onChange();
    }

    protected void onChange() {
    }

    protected boolean allowIO() {
        return true;
    }

    @Override
    public int getComparatorOverride() {
        return AbstractContainerMenu.m_38938_((Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }
}

