/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.barrel_planter;

import github.mrh0.buildersaddition2.blocks.blockstate.PlanterState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BarrelPlanterBlock
extends Block {
    public static final EnumProperty<PlanterState> STATE = EnumProperty.m_61587_((String)"soil", PlanterState.class);

    public BarrelPlanterBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)PlanterState.DIRT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        if (state.m_61143_(STATE) == PlanterState.FARMLAND) {
            return plantable.getPlantType(level, pos) == PlantType.CROP || super.canSustainPlant(state, level, pos, facing, plantable);
        }
        return plantable.getPlantType(level, pos) != PlantType.CROP && !super.canSustainPlant(state, level, pos, facing, plantable);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(STATE) == PlanterState.FARMLAND) {
            return InteractionResult.PASS;
        }
        ItemStack i = player.m_21120_(hand);
        if (i.m_41720_() instanceof HoeItem) {
            i.m_41622_(1, (LivingEntity)player, e -> {});
            level.m_46597_(pos, (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)PlanterState.FARMLAND)));
            level.m_5594_(player, pos, SoundEvents.f_11996_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

