/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.arcade.games;

import github.mrh0.buildersaddition2.blocks.arcade.ArcadeDisplay;
import github.mrh0.buildersaddition2.blocks.arcade.games.AbstractArcadeGame;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;

public class ArcadeBreakout
extends AbstractArcadeGame {
    final int padWidth = 6;
    final float padSpeed = 1.0f;
    final float ballSpeed = 1.0f;
    final ArrayList<Ball> balls = new ArrayList();

    public ArcadeBreakout(ArcadeDisplay display) {
        super(display);
    }

    @Override
    public void start() {
        super.start();
        this.display.clear();
        this.balls.add(new Ball(this.display.width / 2, this.display.height / 2));
        this.display.setFgRenderer(this::fgRender);
        this.display.setColors(0, 15);
        this.display.print(0, "Work in progress.");
    }

    private void fgRender(GuiGraphics gg, int x, int y, int width, int height) {
        for (Ball b : this.balls) {
            b.render(gg, x, y, width, height);
        }
    }

    @Override
    public void frame(long step, float partial) {
        super.frame(step, partial);
        for (Ball b : this.balls) {
            b.update(partial);
        }
    }

    private class Ball {
        public float x;
        public float y;
        public float vx = 0.0f;
        public float vy = 0.0f;

        public Ball(int x, int y) {
            this.x = x;
            this.y = y;
            this.setVelocityAngle((float)Math.random() * 360.0f, 1.0f);
        }

        public void update(float partial) {
            this.x += this.vx * partial;
            this.y += this.vy * partial;
            if (this.x + this.vx <= 0.0f) {
                this.x = 0.0f;
                this.bounceVertical();
            }
            if (this.y + this.vy <= 0.0f) {
                this.y = 0.0f;
                this.bounceHorizontal();
            }
            if (this.x + this.vx >= (float)(ArcadeBreakout.this.display.width - 1)) {
                this.x = ArcadeBreakout.this.display.width - 1;
                this.bounceVertical();
            }
            if (this.y + this.vy >= (float)(ArcadeBreakout.this.display.height - 1)) {
                this.y = ArcadeBreakout.this.display.height - 1;
                this.bounceHorizontal();
            }
        }

        public void render(GuiGraphics gg, int sx, int sy, int swidth, int sheight) {
            Objects.requireNonNull(ArcadeBreakout.this.display);
            int n = sx + (int)(this.x * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.display);
            int n2 = sy + (int)(this.y * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.display);
            Objects.requireNonNull(ArcadeBreakout.this.display);
            int n3 = sx + 8 + (int)(this.x * 8.0f);
            Objects.requireNonNull(ArcadeBreakout.this.display);
            Objects.requireNonNull(ArcadeBreakout.this.display);
            gg.m_280509_(n, n2, n3, sy + 8 + (int)(this.y * 8.0f), ArcadeDisplay.getRenderColor(10));
        }

        public int getX() {
            return (int)this.x;
        }

        public int getY() {
            return (int)this.y;
        }

        public void bounceVertical() {
            this.vx = -this.vx;
            ArcadeBreakout.this.playSound(12, 0);
        }

        public void bounceHorizontal() {
            this.vy = -this.vy;
            ArcadeBreakout.this.playSound(12, 0);
        }

        public void setVelocity(float x, float y) {
            this.vx = x;
            this.vy = y;
        }

        public void setVelocityAngle(float angle, float v) {
            this.setVelocity((float)Math.cos(Math.toRadians(angle)) * v, (float)Math.sin(Math.toRadians(angle)) * v);
        }
    }
}

