/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.arcade;

import github.mrh0.buildersaddition2.blocks.arcade.ArcadeDisplay;
import github.mrh0.buildersaddition2.blocks.arcade.games.AbstractArcadeGame;
import github.mrh0.buildersaddition2.blocks.arcade.games.ArcadeCredits;
import github.mrh0.buildersaddition2.blocks.arcade.games.ArcadeSnake;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ArcadeManager {
    public static ArcadeManager instance = null;
    private final ArrayList<GameConstructor> games;
    private final ArrayList<Component> names;

    public ArcadeManager() {
        if (instance == null) {
            instance = this;
        }
        this.games = new ArrayList();
        this.names = new ArrayList();
    }

    public void add(GameConstructor game, String key) {
        this.games.add(game);
        this.names.add((Component)Component.m_237115_((String)("arcade.buildersaddition2.game." + key)));
    }

    public List<GameConstructor> getGames() {
        return this.games;
    }

    public GameConstructor getGame(int index) {
        return this.games.get(index);
    }

    public String getGameName(int index) {
        return this.names.get(index).getString();
    }

    public static void init() {
        new ArcadeManager();
        instance.add(ArcadeSnake::new, "snake");
        instance.add(ArcadeCredits::new, "credits");
    }

    public static interface GameConstructor {
        public AbstractArcadeGame construct(ArcadeDisplay var1);
    }
}

