/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.arcade;

import java.util.Arrays;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ArcadeDisplay {
    public final int width = 40;
    public final int height = 25;
    public final int cellWidth = 8;
    public final int cellHeight = 8;
    public final short[] screen = new short[1000];
    public static final int[] fgColors = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
    private int bg = 0;
    private int fg = 0;
    private ScreenRender fgRenderer = null;
    private ScreenRender bgRenderer = null;

    public ArcadeDisplay() {
        this.clear();
    }

    public void setBgRenderer(ScreenRender bgr) {
        this.bgRenderer = bgr;
    }

    public void setFgRenderer(ScreenRender fgr) {
        this.fgRenderer = fgr;
    }

    public void clear() {
        Arrays.fill(this.screen, ArcadeDisplay.encode('\u0000', this.bg, this.fg));
    }

    public void clear(int x, int y, int w, int h) {
        for (int ix = x; ix < this.screen.length && ix < x + w; ++ix) {
            for (int iy = y; iy < this.screen.length && iy < y + h; ++iy) {
                this.screen[this.getIndex((int)ix, (int)iy)] = ArcadeDisplay.encode('\u0000', this.bg, this.fg);
            }
        }
    }

    public void testScreen() {
        for (int i = 0; i < this.screen.length; ++i) {
            this.screen[i] = ArcadeDisplay.encode('\u0000', i % 16, this.fg);
        }
    }

    public int getIndex(int x, int y) {
        int i = y * 40 + x;
        if (i < 0) {
            return 0;
        }
        if (i >= 1000) {
            return 0;
        }
        return i;
    }

    public int getX(int i) {
        return i % 40;
    }

    public int getY(int i) {
        return i / 40;
    }

    public static short encode(char c, int bg, int fg) {
        return (short)((c << 8) + ((fg & 0xF) << 4) + (bg & 0xF));
    }

    private static char getChar(short s) {
        return (char)(s >> 8 & 0xFF);
    }

    private static int getBg(short s) {
        return s & 0xF;
    }

    private static int getFg(short s) {
        return s >> 4 & 0xF;
    }

    public static int getHexColor(int i) {
        return fgColors[i];
    }

    public static int getRenderColor(int i) {
        return ArcadeDisplay.getHexColor(i) + -16777216;
    }

    public int print(int pos, String text) {
        int i;
        for (i = 0; i + pos < this.screen.length && i < text.length(); ++i) {
            this.screen[i + pos] = ArcadeDisplay.encode(text.charAt(i), this.bg, this.fg);
        }
        return i;
    }

    public int print(int x, int y, String text) {
        return this.print(this.getIndex(x, y), text);
    }

    public int print(int x, int y, Component text) {
        int i = this.getIndex(x, y);
        return this.print(i, text.m_130668_(1000 - i));
    }

    public void setBg(int col) {
        this.bg = col;
    }

    public void setFg(int col) {
        this.fg = col;
    }

    public void setColors(int bg, int fg) {
        this.setBg(bg);
        this.setFg(fg);
    }

    public short getDataAt(int x, int y) {
        return this.screen[this.getIndex(x, y)];
    }

    public int getBackground(int x, int y) {
        return ArcadeDisplay.getBg(this.getDataAt(x, y));
    }

    public int getForeground(int x, int y) {
        return ArcadeDisplay.getFg(this.getDataAt(x, y));
    }

    public char getChar(int x, int y) {
        return ArcadeDisplay.getChar(this.getDataAt(x, y));
    }

    public static void main(String[] args) {
        short e = ArcadeDisplay.encode('z', 3, 14);
        System.out.println(Integer.toBinaryString(e));
        System.out.println(ArcadeDisplay.getChar(e) + ":" + ArcadeDisplay.getBg(e) + ":" + ArcadeDisplay.getFg(e));
    }

    public void renderBackground(GuiGraphics gg, int swidth, int sheight) {
        int startx = swidth / 2 - 160;
        int starty = sheight / 2 - 100;
        for (int i = 0; i < this.screen.length; ++i) {
            int x = startx + this.getX(i) * 8;
            int y = starty + this.getY(i) * 8;
            gg.m_280509_(x, y, x + 8, y + 8, ArcadeDisplay.getRenderColor(ArcadeDisplay.getBg(this.screen[i])));
        }
        if (this.bgRenderer != null) {
            this.bgRenderer.render(gg, startx, starty, 320, 200);
        }
    }

    public void renderForeground(GuiGraphics gg, Font fr, int swidth, int sheight) {
        int startx = swidth / 2 - 160;
        int starty = sheight / 2 - 100;
        for (int i = 0; i < this.screen.length; ++i) {
            int x = startx + this.getX(i) * 8;
            int y = starty + this.getY(i) * 8;
            if (ArcadeDisplay.getChar(this.screen[i]) == '\u0000') continue;
            gg.m_280430_(fr, (Component)Component.m_237115_((String)("" + ArcadeDisplay.getChar(this.screen[i]))), x + 1, y, ArcadeDisplay.getHexColor(ArcadeDisplay.getFg(this.screen[i])));
        }
        if (this.fgRenderer != null) {
            this.fgRenderer.render(gg, startx, starty, 320, 200);
        }
    }

    public static interface ScreenRender {
        public void render(GuiGraphics var1, int var2, int var3, int var4, int var5);
    }
}

