/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.arcade;

import github.mrh0.buildersaddition2.blocks.arcade.ArcadeBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public class ArcadeBlueprint
extends BlockBlueprint<WoodVariant, ArcadeBlock> {
    public ArcadeBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "arcade";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Arcade";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<ArcadeBlock> getBlock(WoodVariant variant) {
        return () -> new ArcadeBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.planks));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<ArcadeBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_top"), this.resource("block/base_arcade_top")).texture("sides", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_bottom"), this.resource("block/base_arcade_bottom")).texture("sides", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_inventory"), this.resource("block/base_arcade_inventory")).texture("sides", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<ArcadeBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant, "_inventory")));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<ArcadeBlock> block, WoodVariant variant) {
        Function<BlockState, ModelFile> modelFunc = state -> switch ((DoubleBlockHalf)state.m_61143_(ArcadeBlock.HALF)) {
            default -> throw new IncompatibleClassChangeError();
            case DoubleBlockHalf.UPPER -> this.blockModel(variant + "_arcade_top");
            case DoubleBlockHalf.LOWER -> this.blockModel(variant + "_arcade_bottom");
        };
        provider.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 1;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped, Items.f_42416_, Items.f_42351_);
    }
}

