/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.arcade;

import github.mrh0.buildersaddition2.BA2;
import github.mrh0.buildersaddition2.blocks.arcade.ArcadeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ArcadeBlock
extends Block
implements MenuProvider {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)13.0);
    private static final VoxelShape SHAPE_EAST_LOWER = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)32.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST_LOWER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)32.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_EAST_UPPER = Block.m_49796_((double)3.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST_UPPER = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);

    public ArcadeBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() >= 255 || !context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    private VoxelShape getShapeForDirection(Direction d, boolean b) {
        return switch (d) {
            case Direction.NORTH -> {
                if (b) {
                    yield SHAPE_NORTH_UPPER;
                }
                yield SHAPE_NORTH_LOWER;
            }
            case Direction.SOUTH -> {
                if (b) {
                    yield SHAPE_SOUTH_UPPER;
                }
                yield SHAPE_SOUTH_LOWER;
            }
            case Direction.EAST -> {
                if (b) {
                    yield SHAPE_EAST_UPPER;
                }
                yield SHAPE_EAST_LOWER;
            }
            case Direction.WEST -> {
                if (b) {
                    yield SHAPE_WEST_UPPER;
                }
                yield SHAPE_WEST_LOWER;
            }
            default -> SHAPE_NORTH_LOWER;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShapeForDirection((Direction)state.m_61143_((Property)FACING), state.m_61143_(HALF) == DoubleBlockHalf.UPPER);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof IForgeServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        IForgeServerPlayer fsp = (IForgeServerPlayer)player;
        fsp.openMenu((MenuProvider)this, extraData -> extraData.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
            } else {
                level.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.m_7531_(id, param);
    }

    public Component m_5446_() {
        return BA2.translatable("container", "arcade");
    }

    @Nullable
    public ArcadeMenu createMenu(int id, Inventory inv, Player player) {
        return new ArcadeMenu(id);
    }

    public static ArcadeMenu createMenu(int id, Inventory inv, FriendlyByteBuf data) {
        return new ArcadeMenu(id);
    }
}

