/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;

public class MutatedExplosionHelper {
    public static void onExplosionDetonate(Level level, Explosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        if (explosion.f_46019_ instanceof MutatedExplosionDamageCalculator) {
            affectedEntities.removeIf(entity -> !MutatedExplosionHelper.isAffectedByExplosion(explosion, entity));
        }
    }

    private static boolean isAffectedByExplosion(Explosion explosion, Entity entity) {
        if (entity.m_6128_(explosion)) {
            return false;
        }
        if (entity instanceof MutantCreeper) {
            return false;
        }
        Entity entity2 = explosion.m_253049_();
        if (entity2 instanceof SkullSpirit) {
            LivingEntity livingEntity;
            SkullSpirit skullSpirit = (SkullSpirit)entity2;
            if (entity == skullSpirit.getTarget()) {
                return !skullSpirit.isAttached();
            }
            return !(entity instanceof LivingEntity) || ChemicalXMobEffect.IS_APPLICABLE.test(livingEntity = (LivingEntity)entity);
        }
        return true;
    }

    public static Explosion explode(Entity source, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        return source.m_9236_().m_255039_(source, Explosion.m_308019_((Level)source.m_9236_(), (Entity)source), (ExplosionDamageCalculator)new MutatedExplosionDamageCalculator(), source.m_20185_(), source.m_20186_(), source.m_20189_(), radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypes.f_123812_, SoundEvents.f_11913_);
    }

    public static class MutatedExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean m_304921_(Explosion explosion, Entity entity) {
            Entity entity2;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_21254_() && (entity2 = explosion.m_253049_()) instanceof MutantCreeper) {
                MutantCreeper mutantCreeper = (MutantCreeper)entity2;
                float entityDamageAmount = this.m_305869_(explosion, entity);
                if (!entity.m_6469_(explosion.f_46018_, entityDamageAmount)) {
                    if (mutantCreeper.isJumpAttacking()) {
                        EntityUtil.disableShield((LivingEntity)player, mutantCreeper.isCharged() ? 200 : 100);
                    } else {
                        player.m_21211_().m_41622_((int)entityDamageAmount * 2, (LivingEntity)player, player1 -> player1.m_21190_(player.m_7655_()));
                    }
                    entity.m_6469_(explosion.f_46018_, entityDamageAmount * 0.5f);
                }
                return false;
            }
            return super.m_304921_(explosion, entity);
        }
    }
}

