/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.config.ServerConfig;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EndersoulHandItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public EndersoulHandItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (context.m_7078_()) {
            return InteractionResult.PASS;
        }
        if (!MutantEnderman.canBlockBeHeld(level, pos, blockState, ModRegistry.ENDERSOUL_HAND_HOLDABLE_IMMUNE_BLOCK_TAG)) {
            return InteractionResult.PASS;
        }
        if (!level.m_7966_(player, pos)) {
            return InteractionResult.PASS;
        }
        if (!player.m_36204_(pos, context.m_43719_(), itemStack)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            level.m_7967_((Entity)new ThrowableBlock(player, blockState, pos));
            level.m_7471_(pos, false);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (!player.m_36341_()) {
            return InteractionResultHolder.m_19098_((Object)itemInHand);
        }
        HitResult result = player.m_19907_((double)((ServerConfig)MutantMonsters.CONFIG.get(ServerConfig.class)).endersoulHandTeleportDistance, 1.0f, false);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".teleport_failed")), true);
            return InteractionResultHolder.m_19100_((Object)itemInHand);
        }
        if (!level.f_46443_) {
            BlockPos startPos = ((BlockHitResult)result).m_82425_();
            BlockPos endPos = startPos.m_121945_(((BlockHitResult)result).m_82434_());
            BlockPos posDown = startPos.m_7495_();
            if (!level.m_46859_(posDown) || !level.m_8055_(posDown).m_280555_()) {
                for (int i = 0; i < 3; ++i) {
                    BlockPos checkPos = startPos.m_6630_(i + 1);
                    if (!level.m_46859_(checkPos)) continue;
                    endPos = checkPos;
                    break;
                }
            }
            level.m_6263_(null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11757_, player.m_5720_(), 1.0f, 1.0f);
            player.m_6021_((double)endPos.m_123341_() + 0.5, (double)endPos.m_123342_(), (double)endPos.m_123343_() + 0.5);
            level.m_5594_(null, endPos, SoundEvents.f_11757_, player.m_5720_(), 1.0f, 1.0f);
            MutantEnderman.teleportAttack((LivingEntity)player);
            EntityUtil.sendParticlePacket((Entity)player, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.m_203334_(), 256);
            player.m_36335_().m_41524_((Item)this, 200);
            itemInHand.m_41622_(4, (LivingEntity)player, player1 -> player1.m_21190_(interactionHand));
        }
        player.f_19789_ = 0.0f;
        player.m_6674_(interactionHand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemInHand, (boolean)level.f_46443_);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41773_() == 0;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }
}

