/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThrowableBlock
extends ThrowableProjectile
implements AdditionalSpawnDataEntity {
    private static final EntityDataAccessor<OptionalInt> OWNER_ENTITY_ID = SynchedEntityData.m_135353_(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Boolean> HELD = SynchedEntityData.m_135353_(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockState blockState = Blocks.f_50440_.m_49966_();
    @Nullable
    private EntityType<?> ownerType;

    public ThrowableBlock(EntityType<? extends ThrowableBlock> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlock(double x, double y, double z, LivingEntity entity) {
        super((EntityType)ModRegistry.THROWABLE_BLOCK_ENTITY_TYPE.m_203334_(), x, y, z, entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.ownerType = entity.m_6095_();
    }

    public ThrowableBlock(MutantEnderman enderman, int id) {
        this(enderman.m_20185_(), enderman.m_20186_() + 4.7, enderman.m_20189_(), (LivingEntity)enderman);
        this.blockState = Block.m_49803_((int)enderman.getHeldBlock(id));
        boolean outer = id <= 1;
        boolean right = (id & 1) == 0;
        LivingEntity attackTarget = enderman.m_5448_();
        Vec3 forward = EntityUtil.getDirVector(this.m_146908_(), outer ? 2.7f : 1.4f);
        Vec3 strafe = EntityUtil.getDirVector(this.m_146908_() + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.m_6034_(this.m_20185_() + forward.f_82479_ + strafe.f_82479_, this.m_20186_() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.m_20189_() + forward.f_82481_ + strafe.f_82481_);
        if (attackTarget != null) {
            double d0 = attackTarget.m_20185_() - this.m_20185_();
            double d1 = attackTarget.m_20227_(0.33) - this.m_20186_();
            double d2 = attackTarget.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            this.m_6686_(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((LivingEntity)enderman);
        }
    }

    public ThrowableBlock(MutantSnowGolem mutantSnowGolem) {
        this(mutantSnowGolem.m_20185_(), mutantSnowGolem.m_20186_() + 1.955 - 0.1 + 1.0, mutantSnowGolem.m_20189_(), (LivingEntity)mutantSnowGolem);
        this.m_146922_(mutantSnowGolem.m_146908_());
        this.blockState = Blocks.f_50126_.m_49966_();
    }

    public ThrowableBlock(Player player, BlockState blockState, BlockPos pos) {
        this((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, (LivingEntity)player);
        this.blockState = blockState;
        this.setHeld(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(HELD, (Object)false);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public EntityType<?> getOwnerType() {
        return this.ownerType;
    }

    public boolean isHeld() {
        return (Boolean)this.f_19804_.m_135370_(HELD);
    }

    private void setHeld(boolean held) {
        this.f_19804_.m_135381_(HELD, (Object)held);
    }

    public void m_5602_(Entity entityIn) {
        super.m_5602_(entityIn);
        if (entityIn != null) {
            this.f_19804_.m_135381_(OWNER_ENTITY_ID, (Object)OptionalInt.of(entityIn.m_19879_()));
        }
    }

    protected float m_7139_() {
        if (this.ownerType == EntityType.f_20532_) {
            return 0.04f;
        }
        return this.ownerType == ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_() ? 0.06f : 0.01f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6087_() {
        return this.m_6084_() && this.ownerType != ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_();
    }

    public boolean m_6094_() {
        return this.isHeld() && this.m_6084_();
    }

    public void m_7334_(Entity entityIn) {
        if (entityIn != this.m_19749_()) {
            super.m_7334_(entityIn);
        }
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                double y = this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_());
                double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                double motx = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                double moty = 0.5f + this.f_19796_.m_188501_() * 2.0f;
                double motz = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.blockState), x, y, z, motx, moty, motz);
            }
        }
    }

    public void m_8119_() {
        if (this.isHeld()) {
            if (!this.m_9236_().f_46443_) {
                this.m_20115_(6, this.m_146886_());
            }
            this.m_6075_();
            Entity thrower = this.m_19749_();
            if (thrower == null) {
                Entity entity;
                OptionalInt optionalInt = (OptionalInt)this.f_19804_.m_135370_(OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.m_9236_().m_6815_(optionalInt.getAsInt())) instanceof LivingEntity) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.m_5602_(thrower);
                }
            } else if (thrower instanceof LivingEntity) {
                Vec3 vec = thrower.m_20154_();
                double x = thrower.m_20185_() + vec.f_82479_ * 1.6 - this.m_20185_();
                double y = thrower.m_20188_() + vec.f_82480_ * 1.6 - this.m_20186_();
                double z = thrower.m_20189_() + vec.f_82481_ * 1.6 - this.m_20189_();
                float offset = 0.6f;
                this.m_20334_(x * (double)offset, y * (double)offset, z * (double)offset);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (!(this.m_9236_().f_46443_ || thrower.m_6084_() && !thrower.m_5833_() && ((LivingEntity)thrower).m_21055_((Item)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_()))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.m_8119_();
            this.f_19812_ = true;
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (!super.m_5603_(entity)) {
            return false;
        }
        return this.ownerType != ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_() || MutantSnowGolem.canHarm(this.m_19749_(), entity);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_41720_() != ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_()) {
            return InteractionResult.PASS;
        }
        if (this.isHeld()) {
            if (this.m_19749_() == player) {
                if (!this.m_9236_().f_46443_) {
                    this.setHeld(false);
                    this.throwBlock((LivingEntity)player);
                }
                itemStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            this.setHeld(true);
            this.m_5602_((Entity)player);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private void throwBlock(LivingEntity thrower) {
        this.m_146922_(thrower.m_146908_());
        this.m_146926_(thrower.m_146909_());
        float f = 0.4f;
        this.m_6686_(-Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f, -Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f, Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f, 1.4f, 1.0f);
    }

    protected void m_6532_(HitResult result) {
        LivingEntity livingEntity;
        Entity thrower = this.m_19749_();
        LivingEntity livingEntity2 = livingEntity = thrower instanceof LivingEntity ? (LivingEntity)thrower : null;
        if (this.ownerType == ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_()) {
            Entity entity;
            for (Mob mobEntity : this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82377_(2.5, 2.0, 2.5), this::m_5603_)) {
                if (!(this.m_20280_((Entity)mobEntity) <= 6.25)) continue;
                mobEntity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, livingEntity), 4.0f + (float)this.f_19796_.m_188503_(3));
            }
            if (result.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)result).m_82443_()).m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)livingEntity), 4.0f) && entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
            this.m_5496_(this.blockState.m_60827_().m_56775_(), 0.8f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.8f);
        } else {
            boolean canOwnerPlace;
            boolean bl = canOwnerPlace = livingEntity instanceof Player && ((Player)livingEntity).m_36326_() || livingEntity instanceof Mob && CommonAbstractions.INSTANCE.getMobGriefingRule(this.m_9236_(), (Entity)livingEntity);
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                this.m_8060_(blockHitResult);
                if (!this.m_9236_().f_46443_) {
                    BlockPos blockPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (canOwnerPlace && this.m_9236_().m_8055_(blockPos).m_247087_() && this.blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) {
                        this.m_9236_().m_46597_(blockPos, this.blockState);
                        this.blockState.m_60734_().m_6402_(this.m_9236_(), blockPos, this.blockState, livingEntity, ItemStack.f_41583_);
                        SoundType soundType = this.blockState.m_60827_();
                        this.m_5496_(soundType.m_56777_(), (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                    } else {
                        this.m_9236_().m_46796_(2001, blockPos, Block.m_49956_((BlockState)this.blockState));
                        if (canOwnerPlace && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)this.blockState.m_60734_());
                        }
                    }
                }
            } else if (result.m_6662_() == HitResult.Type.ENTITY && !this.m_9236_().f_46443_) {
                Entity entity = ((EntityHitResult)result).m_82443_();
                if (entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)livingEntity), 4.0f) && entity.m_6095_() == EntityType.f_20566_) {
                    return;
                }
                this.m_9236_().m_46796_(2001, this.m_20183_(), Block.m_49956_((BlockState)this.blockState));
                if (canOwnerPlace && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)this.blockState.m_60734_());
                }
            }
            for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(2.0), this::m_5603_)) {
                if (entity.m_7306_((Entity)livingEntity) || !(this.m_20280_(entity) <= 4.0)) continue;
                entity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, livingEntity), (float)(6 + this.f_19796_.m_188503_(3)));
            }
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        compound.m_128379_("Held", this.isHeld());
        if (this.ownerType != null) {
            compound.m_128359_("OwnerType", BuiltInRegistries.f_256780_.m_7981_(this.ownerType).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHeld(compound.m_128471_("Held"));
        if (compound.m_128425_("BlockState", 10)) {
            this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("BlockState"));
        }
        if (compound.m_128441_("OwnerType")) {
            this.ownerType = EntityType.m_20632_((String)compound.m_128461_("OwnerType")).orElse(null);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        buffer.m_130130_(Block.m_49956_((BlockState)this.blockState));
        buffer.m_130070_(this.ownerType == null ? "" : BuiltInRegistries.f_256780_.m_7981_(this.ownerType).toString());
    }

    @Override
    public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        this.blockState = Block.m_49803_((int)additionalData.m_130242_());
        this.ownerType = EntityType.m_20632_((String)additionalData.m_130136_(Short.MAX_VALUE)).orElse(null);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return AdditionalSpawnDataEntity.getPacket(this);
    }
}

