/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SkullSpirit
extends Entity {
    private static final EntityDataAccessor<OptionalInt> TARGET_ENTITY_ID = SynchedEntityData.m_135353_(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.m_135353_(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Mob target;
    private int startTick = 15;
    private int attachedTick = 80 + this.f_19796_.m_188503_(40);
    private UUID targetUUID;
    @Nullable
    private UUID conversionStarter;

    public SkullSpirit(EntityType<? extends SkullSpirit> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public SkullSpirit(Level level, Mob target, @Nullable UUID conversionStarter) {
        this((EntityType<? extends SkullSpirit>)((EntityType)ModRegistry.SKULL_SPIRIT_ENTITY_TYPE.m_203334_()), level);
        this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)OptionalInt.of(target.m_19879_()));
        this.conversionStarter = conversionStarter;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ENTITY_ID, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(ATTACHED, (Object)false);
    }

    public boolean isAttached() {
        return (Boolean)this.f_19804_.m_135370_(ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.f_19804_.m_135381_(ATTACHED, (Object)attached);
    }

    public Mob getTarget() {
        return this.target;
    }

    public boolean m_6090_() {
        return true;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TARGET_ENTITY_ID.equals(key)) {
            ((OptionalInt)this.f_19804_.m_135370_(TARGET_ENTITY_ID)).ifPresent(id -> {
                Entity entity = this.m_9236_().m_6815_(id);
                if (entity instanceof Mob) {
                    Mob mob;
                    this.target = mob = (Mob)entity;
                }
            });
        }
    }

    public void m_8119_() {
        Entity entity;
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID)) instanceof Mob) {
            Mob mob = (Mob)entity;
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)OptionalInt.of(mob.m_19879_()));
            this.targetUUID = null;
        }
        if (this.target != null && this.target.m_6084_()) {
            if (this.isAttached()) {
                if (!this.m_9236_().f_46443_) {
                    this.target.m_20334_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), this.target.m_20184_().f_82480_, (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f));
                    if (--this.attachedTick <= 0) {
                        EntityType<?> mutantType = ChemicalXMobEffect.getMutantOf(this.target);
                        if (mutantType != null && this.f_19796_.m_188503_(4) != 0) {
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                            Mob mutant = this.target.m_21406_(mutantType, true);
                            if (mutant != null) {
                                Player player;
                                mutant.m_21530_();
                                AABB boundingBox = mutant.m_20191_();
                                for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)mutant.m_20186_()), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
                                    if (!(this.m_9236_().m_8055_(pos).m_60800_((BlockGetter)this.m_9236_(), pos) > -1.0f)) continue;
                                    this.m_9236_().m_46961_(pos, true);
                                }
                                if (this.conversionStarter != null && (player = this.m_9236_().m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)mutant);
                                }
                            }
                        } else {
                            this.setAttached(false);
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                        }
                        this.m_146870_();
                    }
                }
                this.m_6034_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                if (this.f_19796_.m_188503_(8) == 0) {
                    this.target.m_6469_(this.m_9236_().m_269111_().m_269425_(), 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = this.target.m_20185_() + (double)(this.f_19796_.m_188501_() * this.target.m_20205_() * 2.0f) - (double)this.target.m_20205_();
                    double posY = this.target.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.target.m_20206_());
                    double posZ = this.target.m_20189_() + (double)(this.f_19796_.m_188501_() * this.target.m_20205_() * 2.0f) - (double)this.target.m_20205_();
                    double x = this.f_19796_.m_188583_() * 0.02;
                    double y = this.f_19796_.m_188583_() * 0.02;
                    double z = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.m_203334_(), posX, posY, posZ, x, y, z);
                }
            } else {
                double z;
                double y;
                double x;
                double d;
                this.f_19854_ = this.m_20185_();
                this.f_19855_ = this.m_20186_();
                this.f_19856_ = this.m_20189_();
                this.m_20256_(Vec3.f_82478_);
                if (this.startTick-- >= 0) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(0.3f * (float)this.startTick / 15.0f), 0.0));
                }
                if ((d = Math.sqrt((x = this.target.m_20185_() - this.m_20185_()) * x + (y = this.target.m_20186_() - this.m_20186_()) * y + (z = this.target.m_20189_() - this.m_20189_()) * z)) != 0.0) {
                    this.m_20256_(this.m_20184_().m_82520_(x / d * 0.2, y / d * 0.2, z / d * 0.2));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                }
                if (!this.m_9236_().f_46443_ && this.m_20280_((Entity)this.target) < 1.0) {
                    this.setAttached(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.f_19796_.m_188501_() - 0.5f) * 1.2f;
                    float yy = (this.f_19796_.m_188501_() - 0.5f) * 1.2f;
                    float zz = (this.f_19796_.m_188501_() - 0.5f) * 1.2f;
                    this.m_9236_().m_7106_((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.m_203334_(), this.m_20185_() + (double)xx, this.m_20186_() + (double)yy, this.m_20189_() + (double)zz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.m_146870_();
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("Attached", this.isAttached());
        compound.m_128405_("AttachedTick", this.attachedTick);
        if (this.target != null) {
            compound.m_128362_("Target", this.target.m_20148_());
        }
        if (this.conversionStarter != null) {
            compound.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.setAttached(compound.m_128471_("Attached"));
        this.attachedTick = compound.m_128451_("AttachedTick");
        if (compound.m_128403_("Target")) {
            this.targetUUID = compound.m_128342_("Target");
        }
        if (compound.m_128403_("ConversionPlayer")) {
            this.conversionStarter = compound.m_128342_("ConversionPlayer");
        }
    }
}

