/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ArrayUtils;

public interface AnimatedEntity
extends AdditionalSpawnDataEntity {
    public EntityAnimation getAnimation();

    public void setAnimation(EntityAnimation var1);

    public EntityAnimation[] getAnimations();

    public int getAnimationTick();

    public void setAnimationTick(int var1);

    default public boolean isAnimationPlaying() {
        return this.getAnimation() != EntityAnimation.NONE;
    }

    @Override
    default public void writeAdditionalAddEntityData(FriendlyByteBuf buffer) {
        buffer.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buffer.writeInt(this.getAnimationTick());
    }

    @Override
    default public void readAdditionalAddEntityData(FriendlyByteBuf additionalData) {
        int animationId = additionalData.readInt();
        this.setAnimation(animationId < 0 ? EntityAnimation.NONE : this.getAnimations()[animationId]);
        this.setAnimationTick(additionalData.readInt());
    }

    public static <T extends Entity> void sendAnimationPacket(T entity, EntityAnimation animation) {
        if (!entity.m_9236_().f_46443_) {
            ((AnimatedEntity)entity).setAnimation(animation);
            ((AnimatedEntity)entity).setAnimationTick(0);
            MutantMonsters.NETWORK.sendToAllTracking((MessageV2)new S2CAnimationMessage(entity.m_19879_(), ArrayUtils.indexOf((Object[])((AnimatedEntity)entity).getAnimations(), (Object)animation)), entity);
        }
    }
}

