/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.util;

import com.google.common.collect.ImmutableMap;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.mixin.accessor.RavagerAccessor;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class EntityUtil {
    private static final Map<EntityType<?>, Item> VANILLA_SKULLS_MAP = ImmutableMap.of((Object)EntityType.f_20558_, (Object)Items.f_42682_, (Object)EntityType.f_20501_, (Object)Items.f_42681_, (Object)EntityType.f_20524_, (Object)Items.f_42678_, (Object)EntityType.f_20497_, (Object)Items.f_42679_, (Object)EntityType.f_20565_, (Object)Items.f_42683_);

    private EntityUtil() {
    }

    public static float getHeadAngle(LivingEntity livingEntity, double x, double z) {
        return Mth.m_14145_((float)((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f), (float)livingEntity.f_20885_);
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(livingEntity.m_9236_(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            areaEffectCloud.m_19712_(1.5f);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaEffectCloud.m_19716_(new MobEffectInstance(effectinstance));
            }
            livingEntity.m_9236_().m_7967_((Entity)areaEffectCloud);
        }
    }

    public static void stunRavager(LivingEntity livingEntity) {
        if (livingEntity instanceof Ravager && ((RavagerAccessor)livingEntity).mutantmonsters$getStunnedTick() == 0) {
            ((RavagerAccessor)livingEntity).mutantmonsters$setStunnedTick(40);
            livingEntity.m_5496_(SoundEvents.f_12362_, 1.0f, 1.0f);
            livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)39);
        }
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (livingEntity.m_21254_()) {
                player.m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
                livingEntity.m_5810_();
                livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
            }
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(entity));
        }
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof Ocelot || livingEntity instanceof Cat;
    }

    public static boolean shouldAttackEntity(LivingEntity target, LivingEntity owner, boolean targetCreepers) {
        if (!(owner instanceof Player)) {
            return true;
        }
        if (target instanceof Creeper) {
            return targetCreepers;
        }
        if (target instanceof TamableAnimal) {
            return !((TamableAnimal)target).m_21830_(owner);
        }
        if (target instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractGolem && !(target instanceof Enemy)) {
            return false;
        }
        return !(target instanceof AbstractHorse) || !((AbstractHorse)target).m_30614_();
    }

    public static void spawnEndersoulParticles(Entity entity, RandomSource random, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (random.m_188501_() - 0.5f) * speed;
            float f1 = (random.m_188501_() - 0.5f) * speed;
            float f2 = (random.m_188501_() - 0.5f) * speed;
            double tempX = entity.m_20185_() + (double)((random.m_188501_() - 0.5f) * entity.m_20205_());
            double tempY = entity.m_20186_() + (double)((random.m_188501_() - 0.5f) * entity.m_20206_()) + 0.5;
            double tempZ = entity.m_20189_() + (double)((random.m_188501_() - 0.5f) * entity.m_20205_());
            entity.m_9236_().m_7106_((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.m_203334_(), tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(Entity entity, ParticleOptions particleData, int amount) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        MutantMonsters.NETWORK.sendToAllNearExcept((MessageV2)new S2CMutantLevelParticlesMessage(particleData, x, y, z, entity.m_20205_(), entity.m_20206_(), entity.m_20205_(), amount), null, x, y, z, 1024.0, entity.m_9236_());
    }

    public static Vec3 getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vec3((double)(-Mth.m_14031_((float)rad) * scale), 0.0, (double)(Mth.m_14089_((float)rad) * scale));
    }

    public static boolean teleportTo(Mob mob, double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean success = false;
        if (mob.m_9236_().m_46749_((BlockPos)pos)) {
            do {
                pos.m_122173_(Direction.DOWN);
            } while (pos.m_123342_() > mob.m_9236_().m_141937_() && !mob.m_9236_().m_8055_((BlockPos)pos).m_280555_());
            pos.m_122173_(Direction.UP);
            AABB bb = mob.m_6972_(Pose.STANDING).m_20384_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (mob.m_9236_().m_45756_((Entity)mob, bb) && !mob.m_9236_().m_46855_(bb)) {
                success = true;
            }
        }
        if (!success) {
            return false;
        }
        mob.m_21573_().m_26573_();
        mob.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return true;
    }

    public static void divertAttackers(Mob targetedMob, LivingEntity newTarget) {
        for (Mob attacker : targetedMob.m_9236_().m_45976_(Mob.class, targetedMob.m_20191_().m_82377_(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.m_5448_() != targetedMob) continue;
            attacker.m_6710_(newTarget);
        }
    }

    public static ItemStack getSkullDrop(EntityType<?> entityType) {
        if (!VANILLA_SKULLS_MAP.containsKey(entityType)) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)VANILLA_SKULLS_MAP.get(entityType));
    }
}

