/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.stream.StreamSupport;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import org.jetbrains.annotations.Nullable;

public class SpawningPreventionHandler {
    private static final Object2IntMap<EntityType<?>> SPAWN_LIMITS_PER_ENTITY_TYPE;

    public static EventResult onEntitySpawn(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        long entitiesOfType;
        int spawnLimit = SPAWN_LIMITS_PER_ENTITY_TYPE.getOrDefault((Object)entity.m_6095_(), -1);
        if (spawnLimit != -1 && (entitiesOfType = StreamSupport.stream(level.m_8583_().spliterator(), false).filter(currentEntity -> currentEntity.m_6095_() == entity.m_6095_()).count()) >= (long)spawnLimit) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    static {
        Object2IntArrayMap map = new Object2IntArrayMap();
        map.put((Object)((EntityType)ModRegistry.BODY_PART_ENTITY_TYPE.m_203334_()), 128);
        map.put((Object)((EntityType)ModRegistry.ENDERSOUL_FRAGMENT_ENTITY_TYPE.m_203334_()), 128);
        map.put((Object)((EntityType)ModRegistry.CREEPER_MINION_EGG_ENTITY_TYPE.m_203334_()), 32);
        SPAWN_LIMITS_PER_ENTITY_TYPE = Object2IntMaps.unmodifiable((Object2IntMap)map);
    }
}

