/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import java.util.Queue;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 16;

    public static EventResult onItemUseTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.m_203334_() && useItem.m_41720_() instanceof BowItem && BowItem.m_40661_((int)(useItem.m_41779_() - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(Player player, ItemStack stack, Level level, MutableInt charge, boolean hasAmmo) {
        if (!(stack.m_41720_() instanceof BowItem)) {
            return EventResult.PASS;
        }
        if (hasAmmo && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModRegistry.MUTANT_SKELETON_SKULL_ITEM.m_203334_()) {
            float velocity = BowItem.m_40661_((int)charge.getAsInt());
            if (!level.f_46443_ && velocity >= 0.1f) {
                ItemStack itemstack = player.m_6298_(stack);
                ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                float[] shotPitches = PlayerEventsHandler.getShotPitches(level.f_46441_, velocity);
                for (int i = 0; i < 2; ++i) {
                    AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemstack, (LivingEntity)player);
                    abstractarrow = CommonAbstractions.INSTANCE.getCustomArrowShotFromBow((BowItem)stack.m_41720_(), abstractarrow, itemstack);
                    abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 3.0f, 1.5f);
                    PlayerEventsHandler.applyPowerEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyPunchEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyFlameEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyPiercingEnchantment(abstractarrow, stack);
                    abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    level.m_7967_((Entity)abstractarrow);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, shotPitches[i + 1]);
                }
            }
        }
        return EventResult.PASS;
    }

    private static float[] getShotPitches(RandomSource random, float velocity) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, PlayerEventsHandler.getRandomShotPitch(flag, random, velocity), PlayerEventsHandler.getRandomShotPitch(!flag, random, velocity)};
    }

    private static float getRandomShotPitch(boolean p_150798_, RandomSource random, float velocity) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f * velocity;
    }

    public static void applyPowerEnchantment(AbstractArrow arrow, ItemStack stack) {
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(AbstractArrow arrow, ItemStack stack) {
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        if (punchLevel > 0) {
            arrow.m_36735_(punchLevel);
        }
    }

    public static void applyFlameEnchantment(AbstractArrow arrow, ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    public static void applyPiercingEnchantment(AbstractArrow arrow, ItemStack stack) {
        int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (pierceLevel > 0) {
            arrow.m_36767_((byte)pierceLevel);
        }
    }

    public static void onPlayerTick$End(Player player) {
        PlayerEventsHandler.playShoulderEntitySound(player, player.m_36331_());
        PlayerEventsHandler.playShoulderEntitySound(player, player.m_36332_());
        if (!player.m_9236_().f_46443_) {
            SeismicWavesCapability capability = (SeismicWavesCapability)ModRegistry.SEISMIC_WAVES_CAPABILITY.get((Object)player);
            Queue<SeismicWave> seismicWaves = capability.getSeismicWaves();
            int oldSize = seismicWaves.size();
            while (seismicWaves.size() > 16) {
                seismicWaves.poll();
            }
            if (!seismicWaves.isEmpty()) {
                PlayerEventsHandler.handleSeismicWave(player, seismicWaves.poll());
            }
            if (oldSize != seismicWaves.size()) {
                capability.setChanged();
            }
        }
    }

    private static void handleSeismicWave(Player player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.m_9236_(), (Entity)player);
        AABB box = new AABB((double)seismicWave.m_123341_(), (double)seismicWave.m_123342_() + 1.0, (double)seismicWave.m_123343_(), (double)seismicWave.m_123341_() + 1.0, (double)seismicWave.m_123342_() + 2.0, (double)seismicWave.m_123343_() + 1.0);
        for (LivingEntity livingEntity : player.m_9236_().m_45976_(LivingEntity.class, box)) {
            if (livingEntity == player || player.m_20202_() == livingEntity) continue;
            livingEntity.m_6469_(DamageSourcesHelper.source((LevelReader)player.m_9236_(), ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (Entity)player), (float)(6 + player.m_217043_().m_188503_(3)));
        }
    }

    private static void playShoulderEntitySound(Player player, @Nullable CompoundTag compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.m_128441_("Silent")) break block2;
                if (compoundNBT.m_128471_("Silent")) break block3;
            }
            EntityType.m_20632_((String)compoundNBT.m_128461_("id")).filter(((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.m_203334_())::equals).ifPresent(entityType -> {
                if (player.m_9236_().f_46441_.m_188503_(500) == 0) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.m_203334_(), player.m_5720_(), 1.0f, (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static EventResult onItemToss(Player player, ItemEntity entityItem) {
        if (!player.m_9236_().f_46443_) {
            boolean isHand;
            ItemStack stack = entityItem.m_32055_();
            boolean bl = isHand = stack.m_41720_() == ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_() && stack.m_41768_();
            if (stack.m_41720_() == Items.f_42545_ || isHand) {
                int count = 0;
                for (EndersoulFragment orb : player.m_9236_().m_45976_(EndersoulFragment.class, player.m_20191_().m_82400_(8.0))) {
                    if (orb.getOwner() != player) continue;
                    ++count;
                    orb.m_146870_();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((Entity)player, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.m_203334_(), 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.m_41773_() - addDmg;
                        stack.m_41721_(Math.max(dmg, 0));
                    } else {
                        ItemStack newStack = new ItemStack((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_());
                        newStack.m_41721_(((Item)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_()).m_41462_() - addDmg);
                        entityItem.m_32045_(newStack);
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

