/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.item.ArmorBlockItem;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityEventsHandler {
    private static final Ingredient PIG_POISON_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_});

    public static EventResult onEntityLoad(Entity entity, ServerLevel level) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob creature = (PathfinderMob)entity;
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                creature.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal(creature, MutantCreeper.class, 16.0f, 1.33, 1.33));
            }
            if (creature.m_6095_() == EntityType.f_20510_) {
                creature.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal(creature, Player.class, 10.0f, 1.25, 1.25, livingEntity -> {
                    Player player;
                    return livingEntity instanceof Player && (PIG_POISON_INGREDIENT.test((player = (Player)livingEntity).m_21205_()) || PIG_POISON_INGREDIENT.test(player.m_21206_()));
                }));
            }
            if (creature.m_6095_() == EntityType.f_20492_) {
                creature.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.8, 0.8));
            }
            if (creature.m_6095_() == EntityType.f_20494_) {
                creature.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.5, 0.5));
            }
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack stackInHand;
        Pig pig;
        if (entity instanceof Pig && !(pig = (Pig)entity).m_21023_(MobEffects.f_19590_) && PIG_POISON_INGREDIENT.test(stackInHand = player.m_21120_(hand))) {
            if (!player.m_7500_()) {
                stackInHand.m_41774_(1);
            }
            pig.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 600));
            return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return EventResultHolder.pass();
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        float damage;
        if (entity instanceof Player && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorBlockItem && !((damage = amount.getAsFloat()) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
            if (!source.m_269533_(DamageTypeTags.f_268745_) || !itemstack.m_41720_().m_41475_()) {
                itemstack.m_41622_((int)damage, entity, livingEntity -> livingEntity.m_21166_(EquipmentSlot.HEAD));
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit) {
        ItemStack itemStack;
        Entity attacker = source.m_7639_();
        if (entity.m_6095_().m_204039_(ModRegistry.SPIDER_PIG_TARGETS_ENTITY_TYPE_TAG) && attacker instanceof SpiderPig) {
            return EventResult.INTERRUPT;
        }
        if ((attacker instanceof MutantCreeper && ((MutantCreeper)attacker).isCharged() || attacker instanceof CreeperMinion && ((CreeperMinion)attacker).isCharged()) && source.m_269533_(DamageTypeTags.f_268415_) && !(itemStack = EntityUtil.getSkullDrop(entity.m_6095_())).m_41619_()) {
            drops.add(new ItemEntity(attacker.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemStack));
        }
        return EventResult.PASS;
    }
}

