/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantZombieModel;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MutantZombieRenderer
extends AlternateMobRenderer<MutantZombie, MutantZombieModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_zombie.png");

    public MutantZombieRenderer(EntityRendererProvider.Context context) {
        super(context, new MutantZombieModel(context.m_174023_(ClientModRegistry.MUTANT_ZOMBIE)), 1.0f);
    }

    public Vec3 getRenderOffset(MutantZombie mutantZombie, float partialTick) {
        return new Vec3(0.0, -0.0975, 0.0);
    }

    public ResourceLocation getTextureLocation(MutantZombie mutantZombie) {
        return TEXTURE_LOCATION;
    }

    protected RenderType getRenderType(MutantZombie mutantZombie, boolean bodyVisible, boolean translucent, boolean glowing) {
        return super.m_7225_((LivingEntity)mutantZombie, bodyVisible, translucent | mutantZombie.vanishTime > 0, glowing);
    }

    protected void setupRotations(MutantZombie mutantZombie, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        if (mutantZombie.f_20919_ > 0) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
            int pitch = Math.min(20, mutantZombie.f_20919_);
            boolean reviving = false;
            if (mutantZombie.f_20919_ > 100) {
                pitch = 140 - mutantZombie.f_20919_;
                reviving = true;
            }
            if (pitch > 0) {
                float f = ((float)pitch + partialTick - 1.0f) / 20.0f * 1.6f;
                if (reviving) {
                    f = ((float)pitch - partialTick) / 40.0f * 1.6f;
                }
                if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                poseStack.m_252781_(Axis.f_252495_.m_252977_(f * this.getFlipDegrees(mutantZombie)));
            }
        } else {
            super.m_7523_((LivingEntity)mutantZombie, poseStack, ageInTicks, rotationYaw, partialTick);
        }
    }

    protected float getFlipDegrees(MutantZombie mutantZombie) {
        return 80.0f;
    }

    protected void scale(MutantZombie mutantZombie, PoseStack poseStack, float partialTick) {
        poseStack.m_85841_(1.3f, 1.3f, 1.3f);
    }

    @Override
    protected float getAlpha(MutantZombie mutantZombie, float partialTick) {
        return mutantZombie.vanishTime > 0 ? 1.0f - ((float)mutantZombie.vanishTime + partialTick) / 100.0f * 0.6f : 1.0f;
    }

    @Override
    protected boolean showsHurtColor(MutantZombie mob) {
        return super.showsHurtColor(mob) || mob.f_20919_ > 0 && mob.getLives() <= 0;
    }
}

