/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantSnowGolemModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class MutantSnowGolemRenderer
extends MobRenderer<MutantSnowGolem, MutantSnowGolemModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_snow_golem/mutant_snow_golem.png");
    public static final ResourceLocation JACK_O_LANTERN_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_snow_golem/jack_o_lantern.png");
    private static final RenderType GLOW_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonsters.id("textures/entity/mutant_snow_golem/glow.png"));

    public MutantSnowGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantSnowGolemModel(context.m_174023_(ClientModRegistry.MUTANT_SNOW_GOLEM)), 0.7f);
        this.m_115326_(new JackOLanternLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.m_174027_()));
        this.m_115326_(new HeldBlockLayer((RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel>)this, context.m_234597_()));
    }

    public void render(MutantSnowGolem mutantSnowGolem, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.m_7392_((Mob)mutantSnowGolem, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        Player owner = mutantSnowGolem.getOwner();
        if (owner != null) {
            poseStack.m_85836_();
            if (this.m_6512_((Mob)mutantSnowGolem)) {
                poseStack.m_85837_(0.0, 0.259, 0.0);
            }
            this.m_7649_((Entity)mutantSnowGolem, (Component)owner.m_5446_().m_6881_().m_130938_(style -> style.m_131155_(Boolean.valueOf(true))), poseStack, multiBufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(MutantSnowGolem mutantSnowGolem) {
        return TEXTURE_LOCATION;
    }

    static class JackOLanternLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final MutantSnowGolemModel headModel;

        public JackOLanternLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> renderer, EntityModelSet entityModelSet) {
            super(renderer);
            this.headModel = new MutantSnowGolemModel(entityModelSet.m_171103_(ClientModRegistry.MUTANT_SNOW_GOLEM_HEAD)).setRenderHeadOnly();
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantSnowGolem mutantSnowGolem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mutantSnowGolem.hasJackOLantern()) {
                if (!mutantSnowGolem.m_20145_()) {
                    ((MutantSnowGolemModel)this.m_117386_()).copyPropertiesTo(this.headModel);
                    JackOLanternLayer.m_117376_((EntityModel)this.headModel, (ResourceLocation)JACK_O_LANTERN_TEXTURE_LOCATION, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)packedLight, (LivingEntity)mutantSnowGolem, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float green = Math.max(0.0f, 0.8f + 0.05f * Mth.m_14089_((float)(ageInTicks * 0.15f)));
                float blue = Math.max(0.0f, 0.15f + 0.2f * Mth.m_14089_((float)(ageInTicks * 0.1f)));
                VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(GLOW_RENDER_TYPE);
                ((MutantSnowGolemModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder, 0xF00000, OverlayTexture.f_118083_, 1.0f, green, blue, 1.0f);
            }
        }
    }

    static class HeldBlockLayer
    extends RenderLayer<MutantSnowGolem, MutantSnowGolemModel> {
        private final BlockRenderDispatcher blockRenderer;

        public HeldBlockLayer(RenderLayerParent<MutantSnowGolem, MutantSnowGolemModel> renderer, BlockRenderDispatcher blockRenderer) {
            super(renderer);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantSnowGolem mutantSnowGolem, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mutantSnowGolem.isThrowing() && mutantSnowGolem.getThrowingTick() < 7) {
                poseStack.m_85836_();
                boolean leftHanded = mutantSnowGolem.m_21526_();
                float scale = Math.min(0.8f, ((float)mutantSnowGolem.getThrowingTick() + partialTick) / 7.0f);
                poseStack.m_85837_(leftHanded ? -0.4 : 0.4, 0.0, 0.0);
                ((MutantSnowGolemModel)this.m_117386_()).translateArm(leftHanded, poseStack);
                poseStack.m_85837_(0.0, 0.9, 0.0);
                poseStack.m_85841_(-scale, -scale, scale);
                poseStack.m_85837_(-0.5, -0.5, 0.5);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                this.blockRenderer.m_110912_(Blocks.f_50126_.m_49966_(), poseStack, multiBufferSource, packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }
}

