/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantArrowModel;
import fuzs.mutantmonsters.client.model.MutantSkeletonModel;
import fuzs.mutantmonsters.client.renderer.entity.MutantArrowRenderer;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class MutantSkeletonRenderer
extends MobRenderer<MutantSkeleton, MutantSkeletonModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_skeleton.png");
    public static final ResourceLocation CROSSBOW_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_crossbow.png");

    public MutantSkeletonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantSkeletonModel(context.m_174023_(ClientModRegistry.MUTANT_SKELETON), context.m_174023_(ClientModRegistry.MUTANT_CROSSBOW)), 0.6f);
        this.m_115326_(new CrossbowLayer((RenderLayerParent<MutantSkeleton, MutantSkeletonModel>)this, context.m_174027_()));
    }

    protected float getFlipDegrees(MutantSkeleton mutantSkeleton) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(MutantSkeleton mutantSkeleton) {
        return TEXTURE_LOCATION;
    }

    static class CrossbowLayer
    extends RenderLayer<MutantSkeleton, MutantSkeletonModel> {
        private final MutantArrowModel model;

        public CrossbowLayer(RenderLayerParent<MutantSkeleton, MutantSkeletonModel> renderer, EntityModelSet entityModelSet) {
            super(renderer);
            this.model = new MutantArrowModel(entityModelSet.m_171103_(ClientModRegistry.MUTANT_ARROW));
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantSkeleton mutantSkeleton, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            poseStack.m_85836_();
            boolean leftHanded = mutantSkeleton.m_21526_();
            ((MutantSkeletonModel)this.m_117386_()).translateHand(leftHanded, poseStack);
            if (leftHanded) {
                poseStack.m_85841_(-1.0f, 1.0f, -1.0f);
            }
            ((MutantSkeletonModel)this.m_117386_()).getCrossbow().m_7695_(poseStack, multiBufferSource.m_6299_(((MutantSkeletonModel)this.m_117386_()).getCrossbow().m_103119_(CROSSBOW_TEXTURE_LOCATION)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            if (mutantSkeleton.getAnimation() == MutantSkeleton.SHOOT_ANIMATION && mutantSkeleton.getAnimationTick() > 10 && mutantSkeleton.getAnimationTick() < 26 || mutantSkeleton.getAnimation() == MutantSkeleton.MULTI_SHOT_ANIMATION && mutantSkeleton.getAnimationTick() > 16 && mutantSkeleton.getAnimationTick() < 24) {
                poseStack.m_85836_();
                ((MutantSkeletonModel)this.m_117386_()).translateHand(leftHanded, poseStack);
                poseStack.m_85837_(leftHanded ? 0.2 : -0.2, 0.4, -1.8);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85841_(1.2f, 1.2f, 1.2f);
                VertexConsumer vertexBuilder = multiBufferSource.m_6299_(this.model.m_103119_(MutantArrowRenderer.TEXTURE_LOCATION));
                this.model.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

