/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.EndersoulLayer;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class MutantEndermanRenderer
extends AlternateMobRenderer<MutantEnderman, EntityModel<MutantEnderman>> {
    private static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/mutant_enderman.png");
    private static final ResourceLocation DEATH_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/death.png");
    private static final RenderType EYES_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonsters.id("textures/entity/mutant_enderman/eyes.png"));
    private static final RenderType DEATH_RENDER_TYPE = RenderType.m_110479_((ResourceLocation)TEXTURE_LOCATION);
    private final MutantEndermanModel endermanModel;
    private final EndermanModel<MutantEnderman> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, new MutantEndermanModel(context.m_174023_(ClientModRegistry.MUTANT_ENDERMAN)), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.f_115290_;
        this.cloneModel = new EndermanModel(context.m_174023_(ClientModRegistry.ENDERMAN_CLONE));
        this.m_115326_(new EyesLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this));
        this.m_115326_(new SoulLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this));
        this.m_115326_(new HeldBlocksLayer((RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>>)this, context.m_234597_()));
    }

    public boolean shouldRender(MutantEnderman mutantEnderman, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)mutantEnderman, camera, camX, camY, camZ)) {
            return true;
        }
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            return mutantEnderman.getTeleportPosition().map(Vec3::m_82539_).map(arg_0 -> ((EntityDimensions)mutantEnderman.m_6095_().m_20680_()).m_20393_(arg_0)).filter(arg_0 -> ((Frustum)camera).m_113029_(arg_0)).isPresent();
        }
        return false;
    }

    public void render(MutantEnderman mutantEnderman, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (mutantEnderman.isClone()) {
            this.f_115290_ = this.cloneModel;
            this.cloneModel.f_102577_ = mutantEnderman.m_5912_();
            this.f_114477_ = 0.5f;
            this.f_114478_ = 0.5f;
        } else {
            this.f_115290_ = this.endermanModel;
            this.f_114477_ = 0.8f;
            this.f_114478_ = mutantEnderman.f_20919_ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(mutantEnderman) : 1.0f;
        }
        this.teleportAttack = false;
        super.m_7392_(mutantEnderman, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            this.teleportAttack = true;
            mutantEnderman.getTeleportPosition().ifPresent(pos -> {
                poseStack.m_85836_();
                double d0 = Mth.m_14139_((double)partialTick, (double)mutantEnderman.f_19790_, (double)mutantEnderman.m_20185_());
                double d1 = Mth.m_14139_((double)partialTick, (double)mutantEnderman.f_19791_, (double)mutantEnderman.m_20186_());
                double d2 = Mth.m_14139_((double)partialTick, (double)mutantEnderman.f_19792_, (double)mutantEnderman.m_20189_());
                poseStack.m_85837_((double)pos.m_123341_() + 0.5 - d0, (double)pos.m_123342_() - d1, (double)pos.m_123343_() + 0.5 - d2);
                super.m_7392_(mutantEnderman, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
                poseStack.m_85849_();
            });
        }
    }

    private static float getDeathProgress(MutantEnderman mutantEnderman) {
        return (float)(mutantEnderman.f_20919_ - 80) / (float)(MutantEnderman.DEATH_ANIMATION.duration() - 80);
    }

    @Override
    protected boolean hasAlternateRender(MutantEnderman mutantEnderman, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (mutantEnderman.f_20919_ > 80) {
            VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(RenderType.m_173235_((ResourceLocation)DEATH_TEXTURE_LOCATION));
            this.f_115290_.m_7695_(poseStack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, MutantEndermanRenderer.getDeathProgress(mutantEnderman));
            VertexConsumer ivertexbuilder1 = multiBufferSource.m_6299_(DEATH_RENDER_TYPE);
            this.f_115290_.m_7695_(poseStack, ivertexbuilder1, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public Vec3 getRenderOffset(MutantEnderman mutantEnderman, float partialTick) {
        boolean death;
        boolean stare = mutantEnderman.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = mutantEnderman.isClone() && mutantEnderman.m_5912_();
        boolean telesmash = mutantEnderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && mutantEnderman.getAnimationTick() < 18;
        boolean bl = death = mutantEnderman.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (!(stare || scream || clone || telesmash || death)) {
            return super.m_7860_((Entity)mutantEnderman, partialTick);
        }
        double shake = 0.03;
        if (clone) {
            shake = 0.02;
        } else if (death) {
            shake = mutantEnderman.getAnimationTick() < 80 ? 0.02 : 0.05;
        } else if (mutantEnderman.getAnimationTick() >= 40) {
            shake *= 0.5;
        }
        return new Vec3(mutantEnderman.m_217043_().m_188583_() * shake, 0.0, mutantEnderman.m_217043_().m_188583_() * shake);
    }

    public ResourceLocation getTextureLocation(MutantEnderman mutantEnderman) {
        return TEXTURE_LOCATION;
    }

    protected RenderType getRenderType(MutantEnderman mutantEnderman, boolean bodyVisible, boolean translucent, boolean glowing) {
        return mutantEnderman.isClone() ? null : super.m_7225_((LivingEntity)mutantEnderman, bodyVisible, translucent, glowing);
    }

    protected float getFlipDegrees(MutantEnderman mutantEnderman) {
        return 0.0f;
    }

    static class EyesLayer
    extends RenderLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        public EyesLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!mutantEnderman.isClone()) {
                VertexConsumer ivertexbuilder = multiBufferSource.m_6299_(EYES_RENDER_TYPE);
                this.m_117386_().m_7695_(poseStack, ivertexbuilder, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, mutantEnderman.f_20919_ > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(mutantEnderman) : 1.0f);
            }
        }
    }

    class SoulLayer
    extends EndersoulLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        public SoulLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> renderer) {
            super(renderer);
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION && mutantEnderman.getAnimationTick() < 10;
            boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
            boolean clone = mutantEnderman.isClone();
            if (teleport || scream || clone) {
                float scale = 0.0f;
                if (teleport) {
                    scale = 1.2f + ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f;
                    }
                }
                if (scream) {
                    scale = mutantEnderman.getAnimationTick() < 40 ? 1.2f + ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f : (mutantEnderman.getAnimationTick() < 160 ? 2.2f : Math.max(0.0f, 2.2f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f));
                }
                poseStack.m_85836_();
                if (!clone) {
                    poseStack.m_85841_(scale, scale * 0.8f, scale);
                }
                super.render(poseStack, multiBufferSource, packedLight, mutantEnderman, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                poseStack.m_85849_();
            }
        }

        @Override
        protected float getAlpha(MutantEnderman mutantEnderman, float partialTick) {
            float alpha = 1.0f;
            if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
                if (!MutantEndermanRenderer.this.teleportAttack && mutantEnderman.getAnimationTick() >= 8) {
                    alpha -= ((float)mutantEnderman.getAnimationTick() - 8.0f + partialTick) / 2.0f;
                }
                if (MutantEndermanRenderer.this.teleportAttack && mutantEnderman.getAnimationTick() < 2) {
                    alpha = ((float)mutantEnderman.getAnimationTick() + partialTick) / 2.0f;
                }
            }
            if (mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
                if (mutantEnderman.getAnimationTick() < 40) {
                    alpha = ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f;
                } else if (mutantEnderman.getAnimationTick() >= 160) {
                    alpha = 1.0f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f;
                }
            }
            return alpha;
        }
    }

    static class HeldBlocksLayer
    extends RenderLayer<MutantEnderman, EntityModel<MutantEnderman>> {
        private final BlockRenderDispatcher blockRenderer;

        public HeldBlocksLayer(RenderLayerParent<MutantEnderman, EntityModel<MutantEnderman>> renderer, BlockRenderDispatcher blockRenderer) {
            super(renderer);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            EntityModel entityModel;
            if (mutantEnderman.getAnimation() != MutantEnderman.CLONE_ANIMATION && (entityModel = this.m_117386_()) instanceof MutantEndermanModel) {
                MutantEndermanModel model = (MutantEndermanModel)entityModel;
                for (int i = 0; i < 4; ++i) {
                    if (mutantEnderman.getHeldBlock(i) <= 0) continue;
                    poseStack.m_85836_();
                    model.translateRotateArm(poseStack, i);
                    poseStack.m_85837_(0.0, 1.2, 0.0);
                    float tick = (float)mutantEnderman.f_19797_ + (float)(i + 1) * 2.0f * (float)Math.PI + partialTick;
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(tick * 10.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(tick * 8.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(tick * 6.0f));
                    poseStack.m_85841_(-0.75f, -0.75f, 0.75f);
                    poseStack.m_85837_(-0.5, -0.5, 0.5);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    this.blockRenderer.m_110912_(Block.m_49803_((int)mutantEnderman.getHeldBlock(i)), poseStack, multiBufferSource, packedLight, OverlayTexture.f_118083_);
                    poseStack.m_85849_();
                }
            }
        }
    }
}

