/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.config.ServerConfig;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.handler.SpawningPreventionHandler;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.S2CAddEntityDataMessage;
import fuzs.mutantmonsters.network.S2CAnimationMessage;
import fuzs.mutantmonsters.network.S2CMutantEndermanHeldBlockMessage;
import fuzs.mutantmonsters.network.S2CMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.C2SCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.init.v3.PotionBrewingRegistry;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import java.util.function.ToDoubleFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"mutantmonsters", (boolean)false);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"mutantmonsters").common(CommonConfig.class).server(ServerConfig.class);

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public void onConstructMod() {
        ModRegistry.touch();
        MutantMonsters.registerMessages();
        MutantMonsters.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.registerServerbound(C2SCreeperMinionTrackerMessage.class, C2SCreeperMinionTrackerMessage::new);
        NETWORK.registerClientbound(S2CMutantLevelParticlesMessage.class, S2CMutantLevelParticlesMessage::new);
        NETWORK.registerClientbound(S2CAddEntityDataMessage.class, S2CAddEntityDataMessage::new);
        NETWORK.registerServerbound(C2SCreeperMinionNameMessage.class, C2SCreeperMinionNameMessage::new);
        NETWORK.registerClientbound(S2CAnimationMessage.class, S2CAnimationMessage::new);
        NETWORK.registerClientbound(S2CSeismicWaveFluidParticlesMessage.class, S2CSeismicWaveFluidParticlesMessage::new);
        NETWORK.registerClientbound(S2CMutantEndermanHeldBlockMessage.class, S2CMutantEndermanHeldBlockMessage::new);
    }

    private static void registerHandlers() {
        LivingHurtCallback.EVENT.register(EntityEventsHandler::onLivingHurt);
        UseItemEvents.TICK.register(PlayerEventsHandler::onItemUseTick);
        ArrowLooseCallback.EVENT.register(PlayerEventsHandler::onArrowLoose);
        PlayerInteractEvents.USE_ENTITY.register(EntityEventsHandler::onEntityInteract);
        PlayerTickEvents.END.register(PlayerEventsHandler::onPlayerTick$End);
        ServerEntityLevelEvents.LOAD.register(EntityEventsHandler::onEntityLoad);
        LivingDropsCallback.EVENT.register(EntityEventsHandler::onLivingDrops);
        ItemEntityEvents.TOSS.register(PlayerEventsHandler::onItemToss);
        ServerEntityLevelEvents.SPAWN.register(SpawningPreventionHandler::onEntitySpawn);
        ExplosionEvents.DETONATE.register(MutatedExplosionHelper::onExplosionDetonate);
    }

    public void onCommonSetup() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.f_43601_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_(), (ItemLike)ModRegistry.HULK_HAMMER_ITEM.m_203334_(), (ItemLike)ModRegistry.CREEPER_SHARD_ITEM.m_203334_(), (ItemLike)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.m_203334_()}), (Potion)ModRegistry.CHEMICAL_X_POTION.m_203334_());
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.m_203334_(), CreeperMinion.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.m_203334_(), EndersoulClone.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.m_203334_(), MutantCreeper.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.m_203334_(), MutantEnderman.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_(), MutantSnowGolem.registerAttributes());
        context.registerEntityAttributes((EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.m_203334_(), SpiderPig.registerAttributes());
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.m_203334_(), MutantSkeleton.registerAttributes());
            context.registerEntityAttributes((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.m_203334_(), MutantZombie.registerAttributes());
        }
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.CREEPER_MINION_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        context.registerSpawnPlacement((EntityType)ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MutantEnderman::canSpawn);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_SNOW_GOLEM_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        context.registerSpawnPlacement((EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.SPIDER_PIG_ENTITY_TYPE.m_203334_(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Animal::m_218104_);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        MutantMonsters.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_CREEPER_SPAWNS_BIOME_TAG, config -> config.mutantCreeperSpawnWeight, EntityType.f_20558_, (EntityType)ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.m_203334_());
        MutantMonsters.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_ENDERMAN_SPAWNS_BIOME_TAG, config -> config.mutantEndermanSpawnWeight, EntityType.f_20566_, (EntityType)ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.m_203334_());
        MutantMonsters.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_SKELETON_SPAWNS_BIOME_TAG, config -> config.mutantSkeletonSpawnWeight, EntityType.f_20524_, (EntityType)ModRegistry.MUTANT_SKELETON_ENTITY_TYPE.m_203334_());
        MutantMonsters.registerMutantSpawn(context, ModRegistry.WITHOUT_MUTANT_ZOMBIE_SPAWNS_BIOME_TAG, config -> config.mutantZombieSpawnWeight, EntityType.f_20501_, (EntityType)ModRegistry.MUTANT_ZOMBIE_ENTITY_TYPE.m_203334_());
    }

    private static void registerMutantSpawn(BiomeModificationsContext context, TagKey<Biome> withoutSpawnsTag, ToDoubleFunction<CommonConfig> spawnWeightGetter, EntityType<?> vanillaEntityType, EntityType<?> mutantEntityType) {
        context.register(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> !biomeLoadingContext.is(withoutSpawnsTag), biomeModificationContext -> MutantMonsters.addMutantSpawn(biomeModificationContext.mobSpawnSettings(), spawnWeightGetter.applyAsDouble((CommonConfig)CONFIG.get(CommonConfig.class)), vanillaEntityType, mutantEntityType));
    }

    private static void addMutantSpawn(MobSpawnSettingsContext spawnSettings, double spawnWeight, EntityType<?> entityType, EntityType<?> mutantEntityType) {
        if (spawnWeight > 0.0) {
            spawnSettings.getSpawnerData(MobCategory.MONSTER).stream().filter(data -> data.f_48404_ == entityType).findAny().ifPresent(spawnerData -> {
                int spawnerDataWeight = Math.max(1, (int)((double)spawnerData.m_142631_().m_146281_() * spawnWeight));
                spawnSettings.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(mutantEntityType, spawnerDataWeight, 1, 1));
            });
            MobSpawnSettings.MobSpawnCost mobSpawnCost = spawnSettings.getSpawnCost(entityType);
            if (mobSpawnCost != null) {
                spawnSettings.setSpawnCost(mutantEntityType, mobSpawnCost.f_48385_(), mobSpawnCost.f_48386_());
            }
        }
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new ItemStack((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_())).displayItems((itemDisplayParameters, output) -> {
            output.m_246326_((ItemLike)ModRegistry.CREEPER_MINION_TRACKER_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.CREEPER_SHARD_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.ENDERSOUL_HAND_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.HULK_HAMMER_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_ARMS_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_LIMB_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_PELVIS_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_RIB_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_RIB_CAGE_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SKULL_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_LEGGINGS_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_BOOTS_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.CREEPER_MINION_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_CREEPER_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_ENDERMAN_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SKELETON_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_SNOW_GOLEM_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.MUTANT_ZOMBIE_SPAWN_EGG_ITEM.m_203334_());
            output.m_246326_((ItemLike)ModRegistry.SPIDER_PIG_SPAWN_EGG_ITEM.m_203334_());
        }).appendEnchantmentsAndPotions());
    }

    public ContentRegistrationFlags[] getContentRegistrationFlags() {
        return new ContentRegistrationFlags[]{ContentRegistrationFlags.BIOME_MODIFICATIONS};
    }
}

