/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import java.awt.Dimension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileInventory
extends ItemStackHandler {
    protected final BlockEntity tile;

    public TileInventory(BlockEntity tile, int size) {
        super(size);
        this.tile = tile;
    }

    public BlockEntity getTile() {
        return this.tile;
    }

    protected void onContentsChanged(int slot) {
        this.tile.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class AbstractScreen<T extends AbstractContainerMenu>
    extends AbstractContainerScreen<T> {
        protected final GuiTexture texture;

        public AbstractScreen(T container, Inventory inv, Component title, GuiTexture texture) {
            super(container, inv, title);
            this.texture = texture;
            this.f_97726_ = texture.size.width;
            this.f_97727_ = texture.size.height;
        }

        public GuiTexture getTexture() {
            return this.texture;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.m_280273_(guiGraphics, mouseX, mouseY, partialTicks);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.m_280072_(guiGraphics, mouseX, mouseY);
        }

        protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            guiGraphics.m_280218_(this.texture.location, i, j, 0, 0, this.f_97726_, this.f_97727_);
        }

        public static class GuiTexture {
            public final Dimension size;
            public final ResourceLocation location;

            public GuiTexture(AbstractForgeMod mod, String name, int width, int height) {
                this.location = GamePath.guiTexture((ResourceLocation)mod.getNamespace().location((String)name), (String[])new String[0]).location;
                this.size = new Dimension(width, height);
            }
        }
    }

    public static abstract class AbstractContainer
    extends AbstractContainerMenu {
        public static final Dimension PLAYER_INVENTORY = new Dimension(9, 3);
        public static final Dimension SLOT_SIZE = new Dimension(18, 18);
        protected final PlayerMainInvWrapper playerInventory;
        protected final TileInventory tileInventory;

        public AbstractContainer(MenuType<?> type, int id, Inventory playerInventory, TileInventory tileInventory) {
            super(type, id);
            this.playerInventory = new PlayerMainInvWrapper(playerInventory);
            this.tileInventory = tileInventory;
        }

        public PlayerMainInvWrapper getPlayerInventory() {
            return this.playerInventory;
        }

        public TileInventory getTileInventory() {
            return this.tileInventory;
        }

        public AbstractContainer addPlayerSlots(int startX, int startY) {
            for (int row = 0; row < AbstractContainer.PLAYER_INVENTORY.height; ++row) {
                for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                    int x = startX + col * this.slotSize().width;
                    int y = startY + row * this.slotSize().height;
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.playerInventory, AbstractContainer.PLAYER_INVENTORY.width + col + row * AbstractContainer.PLAYER_INVENTORY.width, x, y));
                }
            }
            for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                int x = startX + col * this.slotSize().width;
                int y = startY + 58;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.playerInventory, col, x, y));
            }
            return this;
        }

        public Dimension slotSize() {
            return SLOT_SIZE;
        }

        public ItemStack m_7648_(Player player, int index) {
            ItemStack itemstack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                ItemStack itemstack1 = slot.m_7993_();
                itemstack = itemstack1.m_41777_();
                int size = this.tileInventory.getSlots();
                if (index < size ? !this.m_38903_(itemstack1, size, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, size, false)) {
                    return ItemStack.f_41583_;
                }
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
            }
            return itemstack;
        }

        public boolean m_6875_(Player player) {
            BlockEntity tile = this.getTileInventory().getTile();
            Level world = tile.m_58904_();
            BlockPos pos = tile.m_58899_();
            Block block = tile.m_58900_().m_60734_();
            return AbstractContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos), (Player)player, (Block)block);
        }
    }

    public static class ItemSlot
    extends SlotItemHandler {
        public final TileInventory tileInventory;

        public ItemSlot(TileInventory tileInventory, int index, int xPosition, int yPosition) {
            super((IItemHandler)tileInventory, index, xPosition, yPosition);
            this.tileInventory = tileInventory;
        }
    }
}

