/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.api.EmojiFromGithub;
import com.hrznstudio.emojiful.datapack.EmojiRecipe;
import com.hrznstudio.emojiful.platform.Services;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.io.FileUtils;

public class CommonClass {
    public static String readStringFromURL(String requestURL) {
        Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8.toString());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    public static JsonElement readJsonFromUrl(String url) {
        String jsonText = CommonClass.readStringFromURL(url);
        JsonElement json = new JsonParser().parse(jsonText);
        return json;
    }

    public static void main(String[] s) throws IOException {
        ClientEmojiHandler.loadTwemojis();
        File folder = new File("raw_assets");
        HashMap<String, List<YamlEmoji>> emojis = new HashMap<String, List<YamlEmoji>>();
        for (String string : Constants.EMOJI_MAP.keySet()) {
            for (Emoji emoji : Constants.EMOJI_MAP.get(string)) {
                boolean found = false;
                String emoji_name = emoji.name.replace("-", "_");
                for (File file : folder.listFiles()) {
                    String filename = file.getName().replace(".png", "").replace("-", "_");
                    if (found || !emoji_name.equals(filename) && !emoji.strings.stream().anyMatch(s1 -> s1.replaceAll(":", "").replace("-", "_").equals(filename)) && !emoji_name.equals(filename.replace("woman", "female").replace("man", "male")) && !emoji.strings.stream().anyMatch(s1 -> s1.replaceAll(":", "").replace("-", "_").equals(filename.replace("woman", "female").replace("man", "male")))) continue;
                    found = true;
                    CommonClass.copy(string, file, emojis, emoji);
                    break;
                }
                if (found) continue;
                System.out.println(emoji.name + "?");
            }
        }
        for (String category : emojis.keySet()) {
            File yamlFile = new File(category + ".yml");
            if (!yamlFile.exists()) {
                yamlFile.createNewFile();
            }
            YamlWriter writer = new YamlWriter((Writer)new FileWriter(category + ".yml"));
            writer.write(emojis.get(category));
            writer.close();
        }
    }

    public static void copy(String category, File sourceFile, HashMap<String, List<YamlEmoji>> emojis, Emoji emoji) {
        File folderTo = new File("assets/" + category);
        if (!folderTo.exists()) {
            folderTo.mkdir();
        }
        try {
            String name = sourceFile.getName().replace(".png", "").replace("-", "_");
            emojis.computeIfAbsent(category, s -> new ArrayList()).add(new YamlEmoji(name, emoji.strings, "assets/" + category + "/" + sourceFile.getName()));
            FileUtils.copyFile((File)sourceFile, (File)new File(folderTo, sourceFile.getName()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Emoji> readCategory(String cat) throws YamlException {
        YamlReader categoryReader = new YamlReader((Reader)new StringReader(CommonClass.readStringFromURL("https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/1.20-plus/" + CommonClass.cleanURL(cat))));
        return Lists.newArrayList((Object[])((Emoji[])categoryReader.read(Emoji[].class)));
    }

    public static String cleanURL(String string) {
        return string.replaceAll(" ", "%20").replaceAll("&", "%26");
    }

    public static void onRecipesUpdated(RecipeManager manager) {
        ClientEmojiHandler.CATEGORIES.removeIf(EmojiCategory::worldBased);
        Constants.EMOJI_LIST.removeIf(Emoji::worldBased);
        if (Services.CONFIG.loadDatapack()) {
            RecipeType<EmojiRecipe> emojiRecipeRecipeType = Services.PLATFORM.getRecipeType();
            List<EmojiRecipe> emojiList = manager.m_44013_(emojiRecipeRecipeType).stream().map(RecipeHolder::f_291008_).toList();
            for (EmojiRecipe emojiRecipe : emojiList) {
                EmojiFromGithub emoji = new EmojiFromGithub();
                emoji.name = emojiRecipe.getName();
                emoji.strings = new ArrayList();
                emoji.strings.add(":" + emojiRecipe.getName() + ":");
                emoji.location = emojiRecipe.getName();
                emoji.url = emojiRecipe.getUrl();
                emoji.worldBased = true;
                Constants.EMOJI_MAP.computeIfAbsent(emojiRecipe.getCategory(), s -> new ArrayList()).add(emoji);
                Constants.EMOJI_LIST.add(emoji);
                if (!ClientEmojiHandler.CATEGORIES.stream().noneMatch(emojiCategory -> emojiCategory.name().equalsIgnoreCase(emojiRecipe.getCategory().toLowerCase()))) continue;
                ClientEmojiHandler.CATEGORIES.add(0, new EmojiCategory(emojiRecipe.getCategory(), true));
            }
            ClientEmojiHandler.indexEmojis();
        }
    }

    public static boolean shouldKeyBeIgnored(int keyCode) {
        return keyCode == 258 || keyCode == 265 || keyCode == 264 || keyCode == 263 || keyCode == 262;
    }

    private static /* synthetic */ boolean lambda$main$5(String filename, String s1) {
        return s1.replaceAll(":", "").replace("-", "_").contains(filename.replace("woman", "female").replace("man", "male"));
    }

    private static /* synthetic */ boolean lambda$main$4(String filename, String s1) {
        return s1.replaceAll(":", "").replace("-", "_").contains(filename);
    }

    private static /* synthetic */ boolean lambda$main$3(String filename, String s1) {
        return s1.replaceAll(":", "").replace("-", "_").equals(filename.replace("woman", "female").replace("man", "male"));
    }

    private static /* synthetic */ boolean lambda$main$2(String filename, String s1) {
        return s1.replaceAll(":", "").replace("-", "_").equals(filename);
    }

    public static class YamlEmoji {
        public String name;
        public List<String> strings;
        public String location;

        public YamlEmoji() {
        }

        public YamlEmoji(String name, List<String> strings, String location) {
            this.name = name;
            this.strings = strings;
            this.location = location;
        }
    }
}

