/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.feature.batching.BlendFuncDepthFunc;
import org.apache.commons.lang3.tuple.Pair;

public class BatchingRenderLayers {
    public static final BiFunction<Integer, BlendFuncDepthFunc, RenderType> COLORED_TEXTURE = Util.m_143821_((id, blendFuncDepthFunc) -> new ImmediatelyFastRenderLayer("texture", VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, false, () -> {
        blendFuncDepthFunc.saveAndApply();
        RenderSystem.setShaderTexture((int)0, (int)id);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
    }, blendFuncDepthFunc::revert));

    public static <A> Function<A, RenderType> memoizeTemp(final Function<A, RenderType> function) {
        return new Function<A, RenderType>(){
            private final Map<A, RenderType> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build().asMap();

            @Override
            public RenderType apply(A arg1) {
                return this.cache.computeIfAbsent(arg1, function);
            }
        };
    }

    public static <A, B> BiFunction<A, B, RenderType> memoizeTemp(final BiFunction<A, B, RenderType> function) {
        return new BiFunction<A, B, RenderType>(){
            private final Map<Pair<A, B>, RenderType> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build().asMap();

            @Override
            public RenderType apply(A arg1, B arg2) {
                return this.cache.computeIfAbsent(Pair.of(arg1, arg2), pair -> (RenderType)function.apply(pair.getLeft(), pair.getRight()));
            }
        };
    }

    private static class ImmediatelyFastRenderLayer
    extends RenderType {
        private ImmediatelyFastRenderLayer(String name, VertexFormat.Mode drawMode, VertexFormat vertexFormat, boolean translucent, Runnable startAction, Runnable endAction) {
            super("immediatelyfast_" + name, vertexFormat, drawMode, 2048, false, translucent, startAction, endAction);
        }
    }
}

