/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class MathsHelper {
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    public static boolean isInRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double getDistanceBetweenPoints(Vec3 firstPos, Vec3 secondPos) {
        double distanceX = firstPos.f_82479_ - secondPos.f_82479_;
        double distanceY = firstPos.f_82480_ - secondPos.f_82480_;
        double distanceZ = firstPos.f_82481_ - secondPos.f_82481_;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }

    public static int getPercentage(int value, int total) {
        return (int)((float)value / (float)total * 100.0f);
    }

    public static double getPixelDistance(int pixels) {
        return (double)pixels / 16.0;
    }

    public static AABB getBoundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AABB(MathsHelper.getPixelDistance(minX), MathsHelper.getPixelDistance(minY), MathsHelper.getPixelDistance(minZ), MathsHelper.getPixelDistance(maxX), MathsHelper.getPixelDistance(maxY), MathsHelper.getPixelDistance(maxZ));
    }

    public static int adjustToRange(int initial, int min, int max) {
        return initial < min ? min : (initial > max ? max : initial);
    }

    public static int multiplyColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Map<Direction, VoxelShape> createHorizontalShapes(double x1, double y1, double z1, double x2, double y2, double z2) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        Direction.Plane.HORIZONTAL.forEach(dir -> shapes.put((Direction)dir, MathsHelper.rotateShape(dir, x1, y1, z1, x2, y2, z2)));
        return shapes;
    }

    public static VoxelShape rotateShape(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return Block.m_49796_((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return Block.m_49796_((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return Block.m_49796_((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
    }

    public static String profileNanoTime(long start, long stop) {
        double duration = stop - start;
        return duration < 10000.0 ? "ns (<0.01ms)" : DECIMAL_2.format(duration / 1000000.0) + "ms";
    }

    public static BlockPos randomOffsetHorizontal(BlockPos startPos, RandomSource rng, int range) {
        return MathsHelper.randomOffset(startPos, rng, range, 0, range);
    }

    public static BlockPos randomOffset(BlockPos startPos, RandomSource rng, int rangeX, int rangeY, int rangeZ) {
        if (rangeX < 0 || rangeY < 0 || rangeZ < 0) {
            throw new IllegalArgumentException("Cannot offset position by '" + rangeX + ", " + rangeY + ", " + rangeZ + "'. Range must be positive!");
        }
        int offsetX = rangeX != 0 ? rng.m_216332_(-rangeX, rangeX) : 0;
        int offsetY = rangeY != 0 ? rng.m_216332_(-rangeY, rangeY) : 0;
        int offsetZ = rangeZ != 0 ? rng.m_216332_(-rangeZ, rangeZ) : 0;
        return startPos.m_7918_(offsetX, offsetY, offsetZ);
    }

    public static Vec3 vec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }
}

