/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.OcelotTailElement;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class OcelotTailModel<T extends Entity>
extends OcelotModel<T> {
    public static final int OCELOT_TAIL_LENGTH = 15;
    private final ModelPart tail;
    private final ModelPart[] tailParts;

    public OcelotTailModel(ModelPart modelPart) {
        super(modelPart);
        this.tail = modelPart.m_171324_("tail1");
        this.tailParts = OcelotTailModel.getTailParts(this.tail);
    }

    public static LayerDefinition createAnimatedBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = OcelotModel.m_170768_((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition1 = partDefinition.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("tail2", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        for (int i = 0; i < 15; ++i) {
            partDefinition1 = i < 7 ? partDefinition1.m_171599_("tail" + (i + 2), CubeListBuilder.m_171558_().m_171514_(0, 16 + i).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f)) : partDefinition1.m_171599_("tail" + (i + 2), CubeListBuilder.m_171558_().m_171514_(4, 8 + i).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        }
        CubeListBuilder cubeListBuilder2 = CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, cubeDeformation);
        partDefinition.m_171599_("left_front_leg", cubeListBuilder2, PartPose.m_171419_((float)1.2f, (float)13.7f, (float)-5.0f));
        partDefinition.m_171599_("right_front_leg", cubeListBuilder2, PartPose.m_171419_((float)-1.2f, (float)13.7f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static ModelPart[] getTailParts(ModelPart tail) {
        ModelPart[] tailParts = new ModelPart[15];
        for (int i = 0; i < tailParts.length; ++i) {
            tailParts[i] = i == 0 ? tail.m_171324_("tail" + (i + 2)) : tailParts[i - 1].m_171324_("tail" + (i + 2));
        }
        return tailParts;
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tail.f_104201_ = this.f_103133_.f_104201_;
        this.tail.f_104202_ = this.f_103133_.f_104202_;
        this.tail.f_104203_ = this.f_103133_.f_104203_;
        OcelotTailModel.setupTailAnim(this.tail, this.tailParts, limbSwing, limbSwingAmount, ageInTicks, OcelotTailElement.animationSpeed, OcelotTailElement.tailLength);
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public static void setupTailAnim(ModelPart tail, ModelPart[] tailParts, float limbSwing, float limbSwingAmount, float ageInTicks, int animationSpeed, int tailLength) {
        float magnitude = (0.5f + limbSwingAmount) * 0.125f;
        float amplitude = limbSwing * 0.6662f + ageInTicks / 4.66f * 0.6662f;
        tail.f_104203_ += Mth.m_14031_((float)amplitude) * magnitude;
        for (int i = 0; i < tailParts.length; ++i) {
            tailParts[i].f_104205_ = 0.0f;
            tailParts[i].f_104203_ = 0.05f;
            tailParts[i].f_104203_ += Mth.m_14031_((float)(amplitude - (float)(i + 1) * (float)animationSpeed * 0.05f)) * magnitude;
            tailParts[i].f_104207_ = i < tailLength;
        }
    }
}

