/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.WobblyCreeperModel;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.world.entity.monster.Creeper;
import net.neoforged.neoforge.common.ModConfigSpec;

public class WobblyCreeperElement
extends ModelElement {
    public static WobbleDirection wobbleDirection;
    private final ModelLayerLocation animatedCreeper;
    private final ModelLayerLocation animatedCreeperArmor;

    public WobblyCreeperElement(BiFunction<String, String, ModelLayerLocation> factory) {
        this.animatedCreeper = factory.apply("animated_creeper", "main");
        this.animatedCreeperArmor = factory.apply("animated_creeper", "armor");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Remember that one very popular \"TNT\" music video by CaptainSparklez with the really cute wobbly Creeper?", "Well, it's in the game now. The full thing, the real deal, exactly like the video."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, final ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(CreeperModel.class, () -> new WobblyCreeperModel(bakery.bakeLayer(this.animatedCreeper), false), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof CreeperPowerLayer) {
                return Optional.of(new CreeperPowerLayer(renderLayerParent, bakery.get()){
                    private final WobblyCreeperModel<Creeper> model;
                    {
                        super(renderer, modelSet);
                        this.model = new WobblyCreeperModel(bakery.bakeLayer(WobblyCreeperElement.this.animatedCreeperArmor), true);
                    }

                    protected EntityModel<Creeper> m_7193_() {
                        return this.model;
                    }
                });
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> context) {
        context.accept(this.animatedCreeper, () -> WobblyCreeperModel.createAnimatedBodyLayer(CubeDeformation.f_171458_, false));
        context.accept(this.animatedCreeperArmor, () -> WobblyCreeperModel.createAnimatedBodyLayer(new CubeDeformation(2.0f), true));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Different directional behaviour modes for the walking animation.").defineEnum("wobble_direction", (Enum)WobbleDirection.SIDE), v -> {
            wobbleDirection = v;
        });
    }

    public static enum WobbleDirection {
        SIDE,
        FRONT,
        CIRCLE,
        RANDOM;

    }
}

