/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Lists;
import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.handler.RemoteSoundHandler;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class SoundDetectionElement
extends ModelElement {
    private final Class<? extends Mob> mobClazz;
    private final SoundEvent[] sounds;

    public SoundDetectionElement(Class<? extends Mob> mobClazz, SoundEvent ... sounds) {
        this.mobClazz = mobClazz;
        this.sounds = sounds;
        RemoteSoundHandler.INSTANCE.addAmbientSounds(mobClazz, Lists.newArrayList((Object[])sounds));
    }

    @Override
    public void setupModelConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept(builder.comment(new String[]{"Mob sounds to play a unique animation for.", "Useful for adding support for modded mob variants which have different sounds from their vanilla counterparts.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."}).define("mob_sounds", Stream.of(this.sounds).map(arg_0 -> ((Registry)BuiltInRegistries.f_256894_).m_7981_(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList())), v -> {
            RemoteSoundHandler.INSTANCE.removeAmbientSounds(this.mobClazz);
            ConfigDataSet soundEvents = ConfigDataSet.from((ResourceKey)Registries.f_256840_, (List)v, (Class[])new Class[0]);
            RemoteSoundHandler.INSTANCE.addAmbientSounds(this.mobClazz, (Collection<SoundEvent>)soundEvents);
        });
    }
}

