/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.text2speech.Narrator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static String lastNarration = "";
    private static long lastNarrationTime = 0L;
    public BoxElement rootElement;
    public ProgressTracker progressTracker = new ProgressTracker();

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!NARRATOR.get().active() || tooltip.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - lastNarrationTime < 500L) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            Narrator narrator = NARRATOR.get();
            narrator.clear();
            narrator.say(StringUtil.m_14406_((String)narration), false);
        });
        lastNarration = narration;
        lastNarrationTime = System.currentTimeMillis();
    }

    public static void clearLastNarration() {
        lastNarration = "";
    }

    public void tickClient() {
        BlockHitResult blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.rootElement = null;
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!ClientProxy.shouldShowWithOverlay(client, client.f_91080_)) {
            return;
        }
        ClientLevel world = client.f_91073_;
        Entity entity = client.m_91288_();
        if (world == null || entity == null) {
            this.rootElement = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.rootElement = null;
            return;
        }
        Accessor<EntityHitResult> accessor = null;
        if (target instanceof BlockHitResult && (blockTarget = (BlockHitResult)target).m_6662_() != HitResult.Type.MISS) {
            BlockState state = RayTracing.wrapBlock((BlockGetter)world, blockTarget, CollisionContext.m_82750_((Entity)entity));
            BlockEntity tileEntity = world.m_7702_(blockTarget.m_82425_());
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = WailaClientRegistration.instance().entityAccessor().hit(entityTarget).entity(entityTarget.m_82443_()).requireVerification().build();
        } else if (client.f_91080_ instanceof BaseOptionsScreen) {
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(Blocks.f_50440_.m_49966_()).hit(new BlockHitResult(entity.m_20182_(), Direction.UP, entity.m_20183_(), false)).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback2 : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
            accessor = callback2.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.rootElement = null;
            return;
        }
        AccessorClientHandler<Accessor<?>> handler = WailaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.rootElement = null;
            return;
        }
        if (accessor.isServerConnected()) {
            if (!accessor.verifyData(accessor.getServerData())) {
                accessor.getServerData().m_128431_().clear();
            }
            boolean request = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    handler.requestData(accessor);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        OverlayRenderer.theme.setValue((Object)IWailaConfig.get().getOverlay().getTheme());
        Accessor<EntityHitResult> accessor0 = accessor;
        WailaClientRegistration.instance().beforeTooltipCollectCallback.call(callback -> callback.beforeCollecting(OverlayRenderer.theme, accessor0));
        Theme theme = (Theme)OverlayRenderer.theme.getValue();
        Preconditions.checkNotNull((Object)theme, (Object)"Theme cannot be null");
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        this.rootElement = new BoxElement(tooltip, IThemeHelper.get().theme().tooltipStyle);
        this.rootElement.tag(Identifiers.ROOT);
        this.rootElement.setThemeIcon(RayTracing.INSTANCE.getIcon(), IThemeHelper.get().theme());
        for (JadeTooltipCollectedCallback callback3 : WailaClientRegistration.instance().tooltipCollectedCallback.callbacks()) {
            callback3.onTooltipCollected(this.rootElement, accessor);
        }
    }
}

