/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.ClientProxy;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final Pattern STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static DecimalFormat dfCommas = new DecimalFormat("0.##");
    public static final DecimalFormat[] dfCommasArray;
    private static boolean betterTextShadow;

    private static void renderGuiItemDecorations(GuiGraphics guiGraphics, Font font, ItemStack stack, int i, int j, @Nullable String text) {
        if (stack.m_41619_()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        if (stack.m_41613_() != 1 || text != null) {
            String s = text == null ? INSTANCE.humanReadableNumber(stack.m_41613_(), "", false, null) : text;
            boolean smaller = s.length() > 3;
            float scale = smaller ? 0.5f : 0.75f;
            int x = smaller ? 32 : 22;
            int y = smaller ? 23 : 13;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            int color = IThemeHelper.get().theme().text.itemAmountColor();
            guiGraphics.m_280056_(font, s, i + x - font.m_92895_(s), j + y, color, true);
            guiGraphics.m_280168_().m_85849_();
        }
        if (stack.m_150947_()) {
            RenderSystem.disableDepthTest();
            int k = stack.m_150948_();
            int l = stack.m_150949_();
            int m = i + 2;
            int n = j + 13;
            guiGraphics.m_285944_(RenderType.m_286086_(), m, n, m + 13, n + 2, -16777216);
            guiGraphics.m_285944_(RenderType.m_286086_(), m, n, m + k, n + 1, l | 0xFF000000);
        }
        guiGraphics.m_280168_().m_85849_();
        ClientProxy.renderItemDecorationsExtra(guiGraphics, font, stack, i, j, text);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static void fill(GuiGraphics guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(guiGraphics.m_280168_().m_85850_().m_252922_(), minX, minY, maxX, maxY, color);
    }

    private static void fill(Matrix4f matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static boolean enableBetterTextShadow() {
        return betterTextShadow;
    }

    public static void setBetterTextShadow(boolean betterTextShadow) {
        DisplayHelper.betterTextShadow = betterTextShadow;
    }

    @Override
    public void drawItem(GuiGraphics guiGraphics, float x, float y, ItemStack stack, float scale, @Nullable String text) {
        if (this.opacity() < 0.5f) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x, y, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280203_(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(guiGraphics, DisplayHelper.CLIENT.f_91062_, stack, 0, 0, text);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public void drawGradientRect(GuiGraphics guiGraphics, float left, float top, float width, float height, int startColor, int endColor) {
        this.drawGradientRect(guiGraphics, left, top, width, height, startColor, endColor, false);
    }

    public void drawGradientRect(GuiGraphics guiGraphics, float left, float top, float width, float height, int startColor, int endColor, boolean horizontal) {
        if (startColor == -1 && endColor == -1) {
            return;
        }
        float zLevel = 0.0f;
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f * this.opacity();
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f * this.opacity();
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (horizontal) {
            buffer.m_252986_(matrix, left + width, top, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_252986_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_252986_(matrix, left, top + height, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_252986_(matrix, left + width, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        } else {
            buffer.m_252986_(matrix, left + width, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_252986_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_252986_(matrix, left, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_252986_(matrix, left + width, top + height, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    @Override
    public void drawBorder(GuiGraphics guiGraphics, float minX, float minY, float maxX, float maxY, float width, int color, boolean corner) {
        DisplayHelper.fill(guiGraphics, minX + width, minY, maxX - width, minY + width, color);
        DisplayHelper.fill(guiGraphics, minX + width, maxY - width, maxX - width, maxY, color);
        if (corner) {
            DisplayHelper.fill(guiGraphics, minX, minY, minX + width, maxY, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(guiGraphics, minX, minY + width, minX + width, maxY - width, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY + width, maxX, maxY - width, color);
        }
    }

    public void drawFluid(GuiGraphics guiGraphics, float xPosition, float yPosition, JadeFluidObject fluid, float width, float height, long capacityMb) {
        if (fluid.isEmpty()) {
            return;
        }
        long amount = JadeFluidObject.bucketVolume();
        MutableFloat scaledAmount = new MutableFloat((float)amount * height / (float)capacityMb);
        if (amount > 0L && scaledAmount.floatValue() < 1.0f) {
            scaledAmount.setValue(1.0f);
        }
        if (scaledAmount.floatValue() > height) {
            scaledAmount.setValue(height);
        }
        ClientProxy.getFluidSpriteAndColor(fluid, (sprite, color) -> {
            if (sprite == null) {
                float maxY = yPosition + height;
                if (color == -1) {
                    color = -1431655766;
                }
                DisplayHelper.fill(guiGraphics, xPosition, maxY - scaledAmount.floatValue(), xPosition + width, maxY, (int)color);
            } else {
                if (this.opacity() != 1.0f) {
                    color = IWailaConfig.IConfigOverlay.applyAlpha(color, this.opacity());
                }
                this.drawTiledSprite(guiGraphics, xPosition, yPosition, width, height, (int)color, scaledAmount.floatValue(), (TextureAtlasSprite)sprite);
            }
        });
    }

    private void drawTiledSprite(GuiGraphics guiGraphics, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        DisplayHelper.setGLColorFromInt(color);
        RenderSystem.enableBlend();
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 0.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        return this.humanReadableNumber(number, unit, milli, dfCommas);
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli, @Nullable Format formatter) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        int exp = 0;
        if (number < 1000.0 || formatter == null && number < 10000.0) {
            formatter = dfCommasArray[2];
        } else {
            exp = (int)Math.log10(number) / 3;
            if (exp > 7) {
                exp = 7;
            }
            if (exp > 0) {
                number /= Math.pow(1000.0, exp);
            }
            if (formatter == null) {
                formatter = number < 10.0 ? dfCommasArray[0] : (number < 100.0 ? dfCommasArray[1] : dfCommasArray[2]);
            }
        }
        if (formatter instanceof NumberFormat) {
            NumberFormat numberFormat = (NumberFormat)formatter;
            sb.append(numberFormat.format(number));
        } else {
            sb.append(formatter.format(new Object[]{number}));
        }
        if (exp == 0) {
            if (milli && number != 0.0) {
                sb.append('m');
            }
        } else {
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(GuiGraphics guiGraphics, String text, float x, float y, int color) {
        this.drawText(guiGraphics, (FormattedText)Component.m_237113_((String)text), x, y, color);
    }

    @Override
    public void drawText(GuiGraphics guiGraphics, FormattedText text, float x, float y, int color) {
        FormattedCharSequence sequence;
        if (text instanceof Component) {
            Component component = (Component)text;
            sequence = component.m_7532_();
        } else {
            sequence = Language.m_128107_().m_5536_(text);
        }
        this.drawText(guiGraphics, sequence, x, y, color);
    }

    @Override
    public void drawText(GuiGraphics guiGraphics, FormattedCharSequence text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().text.shadow();
        if (this.opacity() != 1.0f) {
            color = IWailaConfig.IConfigOverlay.applyAlpha(color, this.opacity());
        }
        betterTextShadow = true;
        guiGraphics.m_280649_(DisplayHelper.CLIENT.f_91062_, text, (int)x, (int)y, color, shadow);
        betterTextShadow = false;
    }

    public void drawGradientProgress(GuiGraphics guiGraphics, float left, float top, float width, float height, float progress, int progressColor) {
        Color color = Color.rgb(progressColor);
        Color highlight = Color.hsl(color.getHue(), color.getSaturation(), Math.min(color.getLightness() + 0.2, 1.0), color.getOpacity());
        if (progress < 0.1f) {
            this.drawGradientRect(guiGraphics, left, top, width * progress, height, progressColor, highlight.toInt(), true);
        } else {
            float hlWidth = width * 0.1f;
            float normalWidth = width * progress - hlWidth;
            DisplayHelper.fill(guiGraphics, left, top, left + normalWidth, top + height, progressColor);
            this.drawGradientRect(guiGraphics, left + normalWidth, top, hlWidth, height, progressColor, highlight.toInt(), true);
        }
    }

    @Override
    public MutableComponent stripColor(Component component) {
        MutableComponent mutableComponent = Component.m_237119_();
        component.m_7451_((style, string) -> {
            if (!string.isEmpty()) {
                MutableComponent literal = Component.m_237113_((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.m_130948_(style.m_131148_((TextColor)null));
                mutableComponent.m_7220_((Component)literal);
            }
            return Optional.empty();
        }, Style.f_131099_);
        return mutableComponent;
    }

    @Override
    public void blitSprite(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int i, int j, int k, int l) {
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity());
        guiGraphics.m_292816_(resourceLocation, i, j, k, l);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void blitSprite(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int i, int j, int k, int l, int m) {
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity());
        guiGraphics.m_295520_(resourceLocation, i, j, k, l, m);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void blitSprite(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p) {
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity());
        guiGraphics.m_294122_(resourceLocation, i, j, k, l, m, n, o, p);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void blitSprite(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity());
        guiGraphics.m_293068_(resourceLocation, i, j, k, l, m, n, o, p, q);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public float opacity() {
        return OverlayRenderer.alpha;
    }

    static {
        for (DecimalFormat format : dfCommasArray = new DecimalFormat[]{dfCommas, new DecimalFormat("0.#"), new DecimalFormat("0")}) {
            format.setRoundingMode(RoundingMode.DOWN);
        }
    }
}

