/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;

public class BoxElement
extends Element
implements IBoxElement {
    private final Tooltip tooltip;
    private final BoxStyle style;
    private int[] padding;
    private IElement icon;
    private float boxProgress;
    private MessageType boxProgressType;
    private ProgressTracker.TrackInfo track;
    private Vec2 contentSize = Vec2.f_82462_;

    public BoxElement(Tooltip tooltip, BoxStyle style) {
        this.tooltip = Objects.requireNonNull(tooltip);
        this.style = Objects.requireNonNull(style);
    }

    private static void chase(TooltipRect rect, ToIntFunction<Rect2i> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int source = getter.applyAsInt(rect.rect);
            int target = getter.applyAsInt(rect.expectedRect);
            float diff = target - source;
            if (diff == 0.0f) {
                return;
            }
            float delta = Minecraft.m_91087_().m_91297_() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (Mth.m_14154_((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)source + diff));
        } else {
            setter.accept(getter.applyAsInt(rect.expectedRect));
        }
    }

    private static int calculateMargin(int margin1, int margin2) {
        if (margin1 >= 0 && margin2 >= 0) {
            return Math.max(margin1, margin2);
        }
        if (margin1 < 0 && margin2 < 0) {
            return Math.min(margin1, margin2);
        }
        return margin1 + margin2;
    }

    @Override
    public Vec2 getSize() {
        if (this.tooltip.isEmpty()) {
            return Vec2.f_82462_;
        }
        float width = 0.0f;
        float height = 0.0f;
        int lineCount = this.tooltip.lines.size();
        Tooltip.Line line = this.tooltip.lines.get(0);
        for (int i = 0; i < lineCount; ++i) {
            Vec2 size = line.size();
            width = Math.max(width, size.f_82470_);
            height += size.f_82471_;
            if (i >= lineCount - 1) continue;
            int marginBottom = line.marginBottom;
            line = this.tooltip.lines.get(i + 1);
            height += (float)BoxElement.calculateMargin(marginBottom, line.marginTop);
        }
        this.contentSize = new Vec2(width, height);
        if (this.icon != null) {
            Vec2 size = this.icon.getCachedSize();
            width += size.f_82470_ + 3.0f;
            height = Math.max(height, size.f_82471_);
        }
        width += (float)(this.padding(Direction2D.LEFT) + this.padding(Direction2D.RIGHT));
        height += (float)(this.padding(Direction2D.UP) + this.padding(Direction2D.DOWN));
        width = Math.max(width, 0.0f);
        height = Math.max(height, 0.0f);
        if (this.icon != null && this.icon.getCachedSize().f_82471_ > this.contentSize.f_82471_) {
            this.setPadding(Direction2D.UP, this.padding(Direction2D.UP) + (int)(this.icon.getCachedSize().f_82471_ - this.contentSize.f_82471_) / 2);
        }
        return new Vec2(width, height);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        float arrowTop;
        if (this.tooltip.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x, y, 0.0f);
        float alpha = IDisplayHelper.get().opacity();
        if (Identifiers.ROOT.equals((Object)this.getTag())) {
            alpha *= IWailaConfig.get().getOverlay().getAlpha();
        }
        this.style.render(guiGraphics, this, 0.0f, 0.0f, maxX - x, maxY - y, alpha);
        if (this.boxProgressType != null) {
            float left = this.style.boxProgressOffset(Direction2D.LEFT);
            float width = maxX - x - left;
            float top = maxY - y - 1.0f + this.style.boxProgressOffset(Direction2D.UP) + this.style.borderWidth();
            float height = 1.0f + this.style.boxProgressOffset(Direction2D.DOWN);
            float progress = this.boxProgress;
            if (this.track == null && this.tag != null) {
                this.track = WailaTickHandler.instance().progressTracker.createInfo(this.tag, progress, false, 0.0f);
            }
            if (this.track != null) {
                progress = this.track.tick(Minecraft.m_91087_().m_91297_());
            }
            ((DisplayHelper)IDisplayHelper.get()).drawGradientProgress(guiGraphics, left, top, width, height, progress, this.style.boxProgressColors.get(this.boxProgressType));
        }
        float contentLeft = this.padding(Direction2D.LEFT);
        float contentTop = this.padding(Direction2D.UP);
        if (this.icon != null) {
            Vec2 iconSize = this.icon.getCachedSize();
            Vec2 offset = this.icon.getTranslation();
            float offsetY = offset.f_82471_;
            float min = contentTop + (float)this.padding(Direction2D.DOWN) + iconSize.f_82471_;
            offsetY = IWailaConfig.get().getOverlay().getIconMode() == IWailaConfig.IconMode.TOP && min < this.getCachedSize().f_82471_ ? (offsetY += contentTop) : (offsetY += (this.size.f_82471_ - iconSize.f_82471_) / 2.0f);
            float offsetX = contentLeft + offset.f_82470_;
            Tooltip.drawDebugBorder(guiGraphics, offsetX, offsetY, this.icon);
            this.icon.render(guiGraphics, offsetX, offsetY, offsetX + iconSize.f_82470_, offsetY + iconSize.f_82471_);
            contentLeft += iconSize.f_82470_ + 3.0f;
        }
        float lineTop = contentTop;
        int lineCount = this.tooltip.lines.size();
        Tooltip.Line line = this.tooltip.lines.get(0);
        for (int i = 0; i < lineCount; ++i) {
            Vec2 lineSize = line.size();
            line.render(guiGraphics, contentLeft, lineTop, maxX - x - (float)this.padding(Direction2D.RIGHT), lineTop + lineSize.f_82471_);
            if (i >= lineCount - 1) continue;
            int marginBottom = line.marginBottom;
            line = this.tooltip.lines.get(i + 1);
            lineTop += lineSize.f_82471_ + (float)BoxElement.calculateMargin(marginBottom, line.marginTop);
        }
        if (this.tooltip.sneakyDetails && (arrowTop = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f) <= 4.0f && (double)(alpha = 1.0f - Math.abs(arrowTop) / 2.0f) > 0.016) {
            guiGraphics.m_280168_().m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            float arrowLeft = contentLeft + (this.contentSize.f_82470_ - (float)mc.f_91062_.m_92895_("\u25be") + 1.0f) / 2.0f;
            guiGraphics.m_280168_().m_252880_(arrowLeft, arrowTop += this.size.f_82471_ - 6.0f, 0.0f);
            int color = IWailaConfig.IConfigOverlay.applyAlpha(IThemeHelper.get().theme().text.colors().info(), alpha);
            DisplayHelper.INSTANCE.drawText(guiGraphics, "\u25be", 0.0f, 0.0f, color);
            guiGraphics.m_280168_().m_85849_();
        }
        Tooltip.drawDebugBorder(guiGraphics, 0.0f, 0.0f, this);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.tooltip.isEmpty() ? null : this.tooltip.getMessage();
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setBoxProgress(MessageType type, float progress) {
        this.boxProgress = progress;
        this.boxProgressType = type;
    }

    @Override
    public float getBoxProgress() {
        return this.boxProgressType == null ? Float.NaN : this.boxProgress;
    }

    @Override
    public void clearBoxProgress() {
        this.boxProgress = 0.0f;
        this.boxProgressType = null;
    }

    @Override
    @Nullable
    public IElement getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable IElement icon) {
        this.icon = icon;
    }

    public void setThemeIcon(@Nullable IElement icon, Theme theme) {
        if (!IWailaConfig.get().getOverlay().shouldShowIcon()) {
            return;
        }
        if (icon != null && theme.iconSlotSprite != null) {
            if (theme.iconSlotSpriteCache == null) {
                GuiSpriteManager guiSprites = Minecraft.m_91087_().m_292761_();
                TextureAtlasSprite textureAtlasSprite = guiSprites.m_118901_(theme.iconSlotSprite);
                GuiSpriteScaling scaling = guiSprites.m_292877_(textureAtlasSprite);
                int[] padding = new int[4];
                Arrays.fill(padding, theme.iconSlotInflation);
                if (scaling instanceof GuiSpriteScaling.NineSlice) {
                    GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
                    GuiSpriteScaling.NineSlice.Border border = nineSlice.f_291546_();
                    padding[0] = padding[0] + border.f_291022_();
                    padding[1] = padding[1] + border.f_290714_();
                    padding[2] = padding[2] + border.f_290453_();
                    padding[3] = padding[3] + border.f_291443_();
                }
                theme.iconSlotSpriteCache = new BoxElement(new Tooltip(), BoxStyle.getSprite(theme.iconSlotSprite, padding));
            }
            ITooltip tooltip1 = theme.iconSlotSpriteCache.getTooltip();
            tooltip1.clear();
            tooltip1.add(icon);
            icon = theme.iconSlotSpriteCache.size(null);
        }
        this.setIcon(icon);
    }

    public void updateExpectedRect(TooltipRect rect) {
        Rect2i bossBarRect;
        Window window = Minecraft.m_91087_().m_91268_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        Vec2 size = this.getCachedSize();
        float x = (float)window.m_85445_() * overlay.tryFlip(overlay.getOverlayPosX());
        float y = (float)window.m_85446_() * (1.0f - overlay.getOverlayPosY());
        float width = size.f_82470_;
        float height = size.f_82471_;
        if (this.style.hasRoundCorner()) {
            x += 1.0f;
            y += 1.0f;
            width += 2.0f;
            height += 2.0f;
        }
        rect.scale = overlay.getOverlayScale();
        float thresholdHeight = (float)window.m_85446_() * overlay.getAutoScaleThreshold();
        if (size.f_82471_ * rect.scale > thresholdHeight) {
            rect.scale = Math.max(rect.scale * 0.5f, thresholdHeight / size.f_82471_);
        }
        Rect2i expectedRect = rect.expectedRect;
        expectedRect.m_173056_((int)(width * rect.scale));
        expectedRect.m_173058_((int)(height * rect.scale));
        expectedRect.m_173047_((int)(x - (float)expectedRect.m_110090_() * overlay.tryFlip(overlay.getAnchorX())));
        expectedRect.m_173054_((int)(y - (float)expectedRect.m_110091_() * overlay.getAnchorY()));
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (bossBarRect = ClientProxy.getBossBarRect()) != null) {
            width = expectedRect.m_110090_();
            height = expectedRect.m_110091_();
            int rw = bossBarRect.m_110090_();
            int rh = bossBarRect.m_110091_();
            x = expectedRect.m_110085_();
            y = expectedRect.m_110086_();
            int rx = bossBarRect.m_110085_();
            int ry = bossBarRect.m_110086_();
            rw += rx;
            rh += ry;
            width += x;
            height += y;
            if ((float)rw > x && (float)rh > y && width > (float)rx && height > (float)ry) {
                expectedRect.m_173054_(bossBarRect.m_110091_());
            }
        }
    }

    public void updateRect(TooltipRect rect) {
        Rect2i src = rect.rect;
        if (src.m_110090_() == 0) {
            src.m_173047_(rect.expectedRect.m_110085_());
            src.m_173054_(rect.expectedRect.m_110086_());
            src.m_173056_(rect.expectedRect.m_110090_());
            src.m_173058_(rect.expectedRect.m_110091_());
        } else {
            BoxElement.chase(rect, Rect2i::m_110085_, arg_0 -> ((Rect2i)src).m_173047_(arg_0));
            BoxElement.chase(rect, Rect2i::m_110086_, arg_0 -> ((Rect2i)src).m_173054_(arg_0));
            BoxElement.chase(rect, Rect2i::m_110090_, arg_0 -> ((Rect2i)src).m_173056_(arg_0));
            BoxElement.chase(rect, Rect2i::m_110091_, arg_0 -> ((Rect2i)src).m_173058_(arg_0));
        }
    }

    @Override
    public int padding(Direction2D direction) {
        if (this.padding != null) {
            return this.padding[direction.ordinal()];
        }
        return this.style.padding(direction);
    }

    @Override
    public void setPadding(Direction2D direction, int value) {
        if (this.padding == null) {
            this.padding = (int[])this.style.padding.clone();
        }
        this.padding[direction.ordinal()] = value;
    }

    @Override
    public BoxStyle getStyle() {
        return this.style;
    }
}

