/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public static final Component OPTION_ON = CommonComponents.f_130653_.m_6881_().m_130938_(style -> style.m_178520_(-4589878));
    public static final Component OPTION_OFF = CommonComponents.f_130654_.m_6881_().m_130938_(style -> style.m_178520_(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public KeyMapping selectedKey;
    private BaseOptionsScreen owner;
    private double targetScroll;
    private Entry defaultParent;
    private int lastActiveIndex;

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
    }

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight) {
        this(owner, client, width, height, y0, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int m_5759_() {
        return Math.min(this.f_93618_, 300);
    }

    protected int m_5756_() {
        return this.owner.f_96543_ - 6;
    }

    public void m_93410_(double d) {
        super.m_93410_(d);
        this.targetScroll = this.m_93517_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        double speed = !ClientProxy.hasFastScroll && Screen.m_96637_() ? 4.5 : 1.5;
        this.targetScroll = this.m_93517_() - deltaY * (double)this.f_93387_ * speed;
        return true;
    }

    public boolean m_93696_() {
        return this.owner.m_7222_() == this;
    }

    protected boolean m_7987_(int i) {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return Objects.equals(this.m_93511_(), this.m_6702_().get(i));
    }

    protected void m_238964_(GuiGraphics guiGraphics, int i, int j, float f, int k, int l, int m, int n, int o) {
        if (this.m_7987_(k) && this.m_5953_(i, j)) {
            this.m_240140_(guiGraphics, m, n, o, -1, -1);
        }
        super.m_238964_(guiGraphics, i, j, f, k, l, m, n, o);
    }

    protected void m_240140_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        guiGraphics.m_280509_(this.m_252754_(), i - 2, this.m_307439_(), i + k + 2, 0x33FFFFFF);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.targetScroll = Math.min(this.targetScroll, (double)this.m_93518_());
        double diff = this.targetScroll - super.m_93517_();
        if (Math.abs(diff) > 3.0E-4) {
            super.m_93410_(super.m_93517_() + diff * (double)delta);
        }
        this.f_168789_ = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            int activeIndex;
            if (this.m_5953_(mouseX, mouseY)) {
                this.f_168789_ = this.m_93412_(mouseX, mouseY);
            }
            if (this.f_168789_ instanceof Title) {
                this.m_6987_(null);
            } else {
                this.m_6987_((AbstractSelectionList.Entry)((Entry)this.f_168789_));
            }
            int n = activeIndex = this.f_168789_ != null ? this.m_6702_().indexOf(this.f_168789_) : Mth.m_14045_((int)((int)this.m_93517_() / this.f_93387_), (int)0, (int)(this.m_5773_() - 1));
            if (activeIndex >= 0 && activeIndex != this.lastActiveIndex) {
                this.lastActiveIndex = activeIndex;
                Entry entry = (Entry)this.m_93500_(activeIndex);
                while (entry != null) {
                    if (entry instanceof Title) {
                        this.currentTitle = (Title)entry;
                        break;
                    }
                    entry = entry.parent;
                }
            }
        }
        this.m_280310_(guiGraphics);
        this.m_239227_(guiGraphics, mouseX, mouseY, delta);
        int k = this.m_93518_();
        k = this.m_93518_();
        if (k > 0) {
            int l = this.m_5756_();
            int m = (int)((float)(this.f_93619_ * this.f_93619_) / (float)this.m_5775_());
            m = Mth.m_14045_((int)m, (int)32, (int)(this.f_93619_ - 8));
            int n = (int)this.m_93517_() * (this.f_93619_ - m) / k + this.m_252907_();
            if (n < this.m_252907_()) {
                n = this.m_252907_();
            }
            guiGraphics.m_280509_(l, this.m_252907_(), l + 6, this.m_306468_(), -16777216);
            guiGraphics.m_292816_(f_291844_, l, n, 6, m);
        }
        this.m_7154_(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        guiGraphics.m_280618_();
        guiGraphics.m_280246_(0.35f, 0.35f, 0.35f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, 0, this.owner.f_96544_ - 32, (float)this.owner.f_96543_, 32.0f, this.owner.f_96543_, this.owner.f_96544_, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280120_(0, this.owner.f_96544_ - 32 - 4, this.owner.f_96543_, this.owner.f_96544_ - 32, 40, 0, -301989888);
    }

    public void save() {
        this.m_6702_().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.m_93412_(x, y);
    }

    public int m_7610_(int i) {
        return super.m_7610_(i);
    }

    public int m_93485_(int i) {
        return super.m_93485_(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public MutableComponent title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, value, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<CycleButton.Builder<Boolean>> builderConsumer) {
        CycleButton.Builder builder = CycleButton.m_168896_((Component)OPTION_ON, (Component)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((CycleButton.Builder<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (CycleButton.Builder<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<CycleButton.Builder<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getClass().getEnumConstants());
        CycleButton.Builder builder = CycleButton.m_168894_(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).m_232502_(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<T> choices(String optionName, T value, List<T> values, Consumer<T> setter, Function<T, Component> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, CycleButton.m_168894_(nameProvider).m_232502_(values), value, setter));
    }

    public void keybind(KeyMapping keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.m_93516_();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.m_93516_();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            block1: for (String keyword : keywords) {
                keyword = keyword.toLowerCase(Locale.ENGLISH);
                for (String message : entry.getMessages()) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent != null) {
                entry = entry.parent;
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
        if (matches.isEmpty()) {
            this.m_7085_((AbstractSelectionList.Entry)new Title(Component.m_237115_((String)"gui.jade.no_results").m_130940_(ChatFormatting.GRAY)));
        }
    }

    public void updateSaveState() {
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.owner.saveButton.f_93623_ = false;
            return;
        }
        this.owner.saveButton.f_93623_ = true;
    }

    public void showOnTop(Entry entry) {
        this.targetScroll = this.f_93387_ * this.m_6702_().indexOf((Object)entry) + 1;
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.selectedKey != null) {
            Options options = Minecraft.m_91087_().f_91066_;
            if (i == 256) {
                options.m_92159_(this.selectedKey, InputConstants.f_84822_);
            } else {
                options.m_92159_(this.selectedKey, InputConstants.m_84827_((int)i, (int)j));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client;
        private final List<String> messages = Lists.newArrayList();
        private final List<AbstractWidget> widgets = Lists.newArrayList();
        private final List<Vector2i> widgetOffsets = Lists.newArrayList();
        @Nullable
        protected String description;
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = Minecraft.m_91087_();
        }

        public static MutableComponent makeTitle(String key) {
            return Component.m_237115_((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.m_137492_((String)"config", (ResourceLocation)new ResourceLocation("jade", key));
        }

        public AbstractWidget getFirstWidget() {
            return this.widgets.isEmpty() ? null : this.widgets.get(0);
        }

        public void addWidget(AbstractWidget widget, int offsetX) {
            this.addWidget(widget, offsetX, -widget.m_93694_() / 2);
        }

        public void addWidget(AbstractWidget widget, int offsetX, int offsetY) {
            this.widgets.add(widget);
            this.widgetOffsets.add(new Vector2i(offsetX, offsetY));
        }

        public List<? extends AbstractWidget> m_6702_() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.m_6702_();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (AbstractWidget widget : this.widgets) {
                Vector2i offset = this.widgetOffsets.get(this.widgets.indexOf(widget));
                widget.m_252865_(rowLeft + width - 110 + offset.x);
                widget.m_253211_(rowTop + height / 2 + offset.y);
                widget.m_88315_(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean b) {
            for (AbstractWidget widget : this.widgets) {
                boolean bl = widget.f_93623_ = !b;
                if (!(widget instanceof EditBox)) continue;
                EditBox box = (EditBox)widget;
                box.m_94186_(!b);
            }
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public Entry parent() {
            return this.parent;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(StringUtil.m_14406_((String)message).toLowerCase(Locale.ENGLISH));
        }

        public void addMessageKey(String key) {
            if (I18n.m_118936_((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(I18n.m_118938_((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public Component narration;
        private final MutableComponent title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (I18n.m_118936_((String)key)) {
                this.description = I18n.m_118938_((String)key, (Object[])new Object[0]);
                this.addMessage(this.description);
            }
            this.narration = Component.m_237110_((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(MutableComponent title) {
            this.title = title;
            this.narration = title;
        }

        public MutableComponent getTitle() {
            return this.title;
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            Font font = this.client.f_91062_;
            int n = this.getTextX(width);
            Objects.requireNonNull(this.client.f_91062_);
            guiGraphics.m_280430_(font, (Component)this.title, n, rowTop + height - 9, 0xFFFFFF);
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.f_91062_.m_92852_((FormattedText)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.f_91062_.m_92852_((FormattedText)this.title);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return List.of(new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.m_169146_(NarratedElementType.TITLE, narration);
                }
            });
        }
    }
}

