/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.PluginConfig;

public class PluginsConfigScreen
extends PreviewOptionsScreen {
    @Nullable
    private Function<OptionsList, OptionsList.Entry> jumpTo;

    public PluginsConfigScreen(Screen parent) {
        super(parent, (Component)Component.m_237115_((String)"gui.jade.plugin_settings"));
        this.saver = PluginConfig.INSTANCE::save;
        this.canceller = PluginConfig.INSTANCE::reload;
    }

    public static Screen createPluginConfigScreen(@Nullable Screen parent, @Nullable Function<OptionsList, OptionsList.Entry> jumpTo, boolean dontSave) {
        PluginsConfigScreen screen = new PluginsConfigScreen(parent);
        screen.jumpTo = jumpTo;
        return screen;
    }

    @Override
    public OptionsList createOptions() {
        OptionsList options = new OptionsList(this, this.f_96541_, this.f_96543_ - 120, this.f_96544_ - 32, 0, 26, PluginConfig.INSTANCE::save);
        boolean noteServerFeature = Minecraft.m_91087_().f_91073_ == null || IWailaConfig.get().getGeneral().isDebug() || !ObjectDataCenter.serverConnected;
        PluginConfig.INSTANCE.getListView().forEach(category -> {
            options.add(new OptionsList.Title(category.title()));
            MutableObject lastPrimary = new MutableObject();
            category.entries().forEach(entry -> {
                OptionValue<?> option = entry.createUI(options, "plugin_" + entry.getId().m_214298_());
                if (entry.isSynced()) {
                    option.setDisabled(true);
                    option.appendDescription(ChatFormatting.DARK_RED + I18n.m_118938_((String)"gui.jade.forced_plugin_config", (Object[])new Object[0]));
                } else if (noteServerFeature && !WailaClientRegistration.instance().isClientFeature(entry.getId())) {
                    option.serverFeature = true;
                }
                if (!PluginConfig.isPrimaryKey(entry.getId())) {
                    if (lastPrimary.getValue() != null) {
                        option.parent((OptionsList.Entry)((Object)((Object)((Object)lastPrimary.getValue()))));
                    }
                } else {
                    lastPrimary.setValue(option);
                }
            });
        });
        return options;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.jumpTo != null) {
            OptionsList.Entry entry = this.jumpTo.apply(this.options);
            if (entry != null) {
                this.options.showOnTop(entry);
            }
            this.jumpTo = null;
        }
    }
}

