/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.BelowOrAboveListEntryTooltipPositioner;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.OptionsNav;
import snownee.jade.gui.config.value.OptionValue;

public abstract class BaseOptionsScreen
extends Screen {
    private final Screen parent;
    private final Set<GuiEventListener> entryWidgets = Sets.newIdentityHashSet();
    public Button saveButton;
    protected Runnable saver;
    protected Runnable canceller;
    protected OptionsList options;
    protected OptionsNav optionsNav;
    private NotUglyEditBox searchBox;

    public BaseOptionsScreen(Screen parent, Component title) {
        super(title);
        this.parent = parent;
    }

    protected void m_7856_() {
        Objects.requireNonNull(this.f_96541_);
        double scroll = this.options == null ? 0.0 : this.options.m_93517_();
        super.m_7856_();
        this.entryWidgets.clear();
        if (this.options != null) {
            this.options.removed();
        }
        this.options = this.createOptions();
        this.options.m_252865_(120);
        this.optionsNav = new OptionsNav(this.options, 120, this.f_96544_ - 32, 18, 18);
        this.searchBox = new NotUglyEditBox(this.f_96547_, 0, 0, 120, 18, this.searchBox, (Component)Component.m_237115_((String)"gui.jade.search"));
        this.searchBox.setBordered(false);
        this.searchBox.setHint((Component)Component.m_237115_((String)"gui.jade.search.hint"));
        this.searchBox.responder = s -> {
            this.options.updateSearch((String)s);
            this.optionsNav.refresh();
        };
        this.searchBox.paddingLeft = 12;
        this.searchBox.paddingTop = 6;
        this.searchBox.paddingRight = 18;
        this.m_142416_((GuiEventListener)this.optionsNav);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)this.options);
        this.searchBox.responder.accept(this.searchBox.getValue());
        this.options.m_93410_(scroll);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.jade.save_and_quit").m_130938_(style -> style.m_178520_(-4589878)), w -> {
            this.options.save();
            this.saver.run();
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.f_96543_ - 100, this.f_96544_ - 25, 90, 20).m_253136_());
        if (this.canceller != null) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, w -> this.m_7379_()).m_252987_(this.saveButton.m_252754_() - 95, this.f_96544_ - 25, 90, 20).m_253136_());
        }
        this.options.updateSaveState();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        OptionsList.Entry entry;
        this.m_280273_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        OptionsList.Entry entry2 = entry = this.options.m_5953_(mouseX, mouseY) ? this.options.getEntryAt(mouseX, mouseY) : null;
        if (entry != null) {
            int valueX;
            if (!Strings.isNullOrEmpty((String)entry.getDescription()) && mouseX >= (valueX = entry.getTextX(this.options.m_5759_())) && mouseX < valueX + entry.getTextWidth()) {
                this.m_262791_(Tooltip.m_257550_((Component)Component.m_237113_((String)entry.getDescription())), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
            }
            if (entry instanceof OptionValue) {
                OptionValue optionValue = (OptionValue)entry;
                if (optionValue.serverFeature) {
                    int x = entry.getTextX(this.options.m_5759_()) + entry.getTextWidth() + 1;
                    int y = this.options.m_7610_(this.options.m_6702_().indexOf((Object)entry)) + 7;
                    if (mouseX >= x && mouseX < x + 4 && mouseY >= y && mouseY < y + 4) {
                        this.m_262791_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.jade.server_feature")), new BelowOrAboveListEntryTooltipPositioner(this.options, entry), false);
                    }
                }
            }
        }
    }

    public abstract OptionsList createOptions();

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.optionsNav.m_5953_(mouseX, mouseY)) {
            return this.optionsNav.m_6050_(mouseX, mouseY, deltaX, deltaY);
        }
        return this.options.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    public void m_7379_() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
    }

    public void m_7861_() {
        this.options.removed();
    }

    public <T extends GuiEventListener & NarratableEntry> T addEntryWidget(T widget) {
        this.entryWidgets.add(widget);
        return (T)super.m_7787_(widget);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        boolean onList = this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_6375_(mouseX, mouseY, p_94697_)) continue;
            this.m_7522_(guieventlistener);
            if (p_94697_ == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public boolean m_6913_() {
        return this.options.selectedKey == null;
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        boolean onList = this.options != null && this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }
}

