/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum MobSpawnerProvider implements IBlockComponentProvider,
IEntityComponentProvider
{
    INSTANCE;


    public static void appendTooltip(ITooltip tooltip, @Nullable Entity displayEntity, MutableComponent name) {
        if (displayEntity == null) {
            return;
        }
        name = Component.m_237110_((String)"jade.spawner", (Object[])new Object[]{name, displayEntity.m_5446_()});
        tooltip.replace(Identifiers.CORE_OBJECT_NAME, (Component)IThemeHelper.get().title(name));
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        MutableComponent name = accessor.getBlock().m_49954_();
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            MobSpawnerProvider.appendTooltip(tooltip, spawner.m_59801_().m_253067_(level, pos), name);
        } else {
            blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof TrialSpawnerBlockEntity) {
                TrialSpawnerBlockEntity spawner = (TrialSpawnerBlockEntity)blockEntity;
                TrialSpawnerData data = spawner.m_307437_().m_305472_();
                MobSpawnerProvider.appendTooltip(tooltip, data.m_307031_(spawner.m_307437_(), level, spawner.m_306453_()), name);
            }
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        MinecartSpawner spawner = (MinecartSpawner)accessor.getEntity();
        MutableComponent name = ObjectNameProvider.getEntityName((Entity)spawner).m_6881_();
        MobSpawnerProvider.appendTooltip(tooltip, spawner.m_150340_().m_253067_(accessor.getLevel(), accessor.getEntity().m_20183_()), name);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_MOB_SPAWNER;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.INSTANCE.getDefaultPriority() + 10;
    }
}

