/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.addon.harvest.ToolHandler;

public class SimpleToolHandler
implements ToolHandler {
    public final Set<Block> blocks = Sets.newIdentityHashSet();
    public final List<TagKey<Block>> blockTags = Lists.newArrayList();
    protected final List<ItemStack> tools = Lists.newArrayList();
    private final ResourceLocation uid;
    private final boolean testIsCorrectTool;

    public SimpleToolHandler(ResourceLocation uid, boolean testIsCorrectTool, List<ItemStack> tools) {
        this.uid = uid;
        this.testIsCorrectTool = testIsCorrectTool;
        if (testIsCorrectTool) {
            Preconditions.checkArgument((!tools.isEmpty() ? 1 : 0) != 0, (Object)"tools cannot be empty");
        } else {
            Preconditions.checkArgument((tools.size() == 1 ? 1 : 0) != 0, (Object)"tools must have only one element");
        }
        this.tools.addAll(tools);
    }

    public static SimpleToolHandler create(ResourceLocation uid, boolean testIsCorrectTool, List<Item> tools) {
        return new SimpleToolHandler(uid, testIsCorrectTool, Lists.transform(tools, Item::m_7968_));
    }

    public boolean matchesBlock(BlockState state) {
        if (this.blocks.contains(state.m_60734_())) {
            return true;
        }
        return this.blockTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0));
    }

    @Override
    public ItemStack test(BlockState state, Level world, BlockPos pos) {
        if (this.matchesBlock(state)) {
            if (this.testIsCorrectTool) {
                if (!state.m_60834_() && state.m_60800_((BlockGetter)world, pos) == 0.0f) {
                    return ItemStack.f_41583_;
                }
                for (ItemStack tool : this.tools) {
                    if (!tool.m_41735_(state)) continue;
                    return tool;
                }
            } else {
                return this.tools.get(0);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<ItemStack> getTools() {
        return this.tools;
    }

    @Override
    public ResourceLocation getUid() {
        return this.uid;
    }

    public SimpleToolHandler addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }

    public SimpleToolHandler addBlockTag(TagKey<Block> tag) {
        this.blockTags.add(tag);
        return this;
    }
}

