/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.version.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class HandshakePacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("journeymap", "version");
    private String version;

    public HandshakePacket() {
    }

    public HandshakePacket(String version) {
        this.version = version;
    }

    public static HandshakePacket decode(FriendlyByteBuf buf) {
        HandshakePacket packet = new HandshakePacket();
        try {
            if (buf.readableBytes() > 1) {
                packet.version = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for handshake: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.m_130070_(this.version);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for handshake: " + t);
        }
    }

    public static void handle(PacketContext<HandshakePacket> ctx) {
        String jsonString = ctx.message().version;
        try {
            Version otherVersion = Version.fromJson(jsonString);
            if (Side.CLIENT.equals((Object)ctx.side())) {
                if (!otherVersion.isValid(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION, ctx.side())) {
                    String message = "Journeymap Version Mismatch need at least " + Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION + " or higher. Current " + ctx.side().opposite() + " version attempt -> " + otherVersion;
                    Minecraft.m_91087_().f_91074_.f_108617_.m_104910_().m_129507_((Component)Component.m_237113_((String)message));
                }
            } else if (otherVersion.isValid(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION, ctx.side())) {
                Journeymap.getInstance().getDispatcher().sendHandshakePacket(ctx.sender(), Journeymap.JM_VERSION.toJson());
            } else {
                String message = "Journeymap Version Mismatch need at least " + Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION + " or higher. Current " + ctx.side().opposite() + " version attempt -> " + otherVersion;
                HandshakePacket.disconnect(ctx.sender(), message);
            }
        }
        catch (Exception e) {
            String message = "Error: Likely due to version mismatch " + ctx.side() + " is running:" + Journeymap.JM_VERSION + " Exception:" + e;
            HandshakePacket.disconnect(ctx.sender(), message + e);
        }
    }

    public static void disconnect(ServerPlayer player, String message) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        MutableComponent text = Component.m_237113_((String)message);
        player.f_8906_.m_141995_((Packet)new ClientboundSystemChatPacket((Component)text, false));
        executorService.schedule(() -> HandshakePacket.lambda$disconnect$0(player, (Component)text), 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$disconnect$0(ServerPlayer player, Component text) {
        player.f_8906_.m_294716_(text);
    }
}

