/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import journeymap.client.JourneymapClient;
import journeymap.common.network.data.NetworkHandler;
import journeymap.common.network.data.PacketContainer;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import journeymap.common.network.packets.PacketManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgeNetworkHandler
extends PacketManager
implements NetworkHandler {
    private final Map<Class<?>, SimpleChannel> CHANNELS = new HashMap();

    public ForgeNetworkHandler() {
        this.PACKET_MAP.forEach((clazz, packetContainer) -> this.registerPacket((PacketContainer)packetContainer));
    }

    private <T> void registerPacket(PacketContainer<T> container) {
        SimpleChannel channel = ChannelBuilder.named((ResourceLocation)container.packetIdentifier()).clientAcceptedVersions((a, b) -> true).serverAcceptedVersions((a, b) -> true).networkProtocolVersion(1).simpleChannel();
        channel.messageBuilder(container.messageType()).decoder(container.decoder()).encoder(container.encoder()).consumerNetworkThread(this.buildHandler(container.handler())).add();
        this.CHANNELS.put(container.messageType(), channel);
    }

    @Override
    public <T> void sendToServer(T packet) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = Minecraft.m_91087_().m_91403_().m_104910_()) || JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            channel.send(packet, PacketDistributor.SERVER.noArg());
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = player.f_8906_.getConnection())) {
            channel.send(packet, PacketDistributor.PLAYER.with((Object)player));
        }
    }

    private <T> BiConsumer<T, CustomPayloadEvent.Context> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            Side side = ctx.getDirection().getReceptionSide().isServer() ? Side.SERVER : Side.CLIENT;
            ServerPlayer player = ctx.getSender();
            handler.accept(new PacketContext<Object>(player, message, side));
            ctx.setPacketHandled(true);
        };
    }
}

