/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class DraggableListPane<T extends Slot>
extends ScrollListPane<T> {
    private boolean clicked = false;
    private Integer frameColor = new Color(-6250336).getRGB();
    private boolean dragging = false;
    private boolean didDrag = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;

    public DraggableListPane(JmUI parent, Minecraft mc, int width, int height, int x, int y) {
        super(parent, mc, x, y, width, height, 20);
        super.m_252865_(x);
        super.m_253211_(y);
    }

    @Override
    public void setSlots(List<T> slots) {
        int newWidth = this.f_93618_;
        int newHeight = this.f_93619_;
        super.setSlots(slots);
        for (Slot slot : this.getRootSlots()) {
            if (!(slot instanceof CategorySlot)) continue;
            newHeight = ((CategorySlot)slot).getAllChildMetadata().size() * 25;
            for (SlotMetadata child : ((CategorySlot)slot).getAllChildMetadata()) {
                String name = child.getName();
                int sWidth = Minecraft.m_91087_().f_91062_.m_92895_(name) * 2;
                newWidth = Math.max(sWidth, newWidth);
            }
        }
        this.updateSize(newWidth, newHeight, 0, super.m_252907_());
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.m_306878_(width, height, x, y);
        this.listWidth = this.f_93618_ - this.hpad * 4;
        this.scrollbarX = this.f_93618_ - this.hpad + super.m_252754_();
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.clicked) {
            graphics.m_280024_(super.m_252754_(), super.m_252907_(), super.m_307439_(), super.m_306468_(), -1072689136, -804253680);
            float alpha = 1.0f;
            DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() - 1, super.m_252907_() - 1, this.f_93618_ + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() - 1, super.m_252907_() + this.f_93619_, this.f_93618_ + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() - 1, super.m_252907_() - 1, 1.0, this.f_93619_ + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), this.f_93618_ + super.m_252754_(), super.m_252907_() - 1, 1.0, this.f_93619_ + 2, this.frameColor, alpha);
        }
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean paneClicked = false;
        if (super.m_5953_(pMouseX, pMouseY) && !(this.m_93412_(pMouseX, pMouseY) instanceof CategorySlot)) {
            paneClicked = super.m_6375_(pMouseX, pMouseY, pButton);
        } else if (super.m_5953_(pMouseX, pMouseY) && this.m_93412_(pMouseX, pMouseY) instanceof CategorySlot) {
            this.mouseDragOffsetX = (int)(pMouseX - (double)super.m_252754_());
            this.mouseDragOffsetY = (int)(pMouseY - (double)super.m_252907_());
            this.dragging = true;
        }
        return paneClicked;
    }

    @Override
    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.dragging) {
            this.didDrag = true;
            int posX = (int)(pMouseX - (double)this.mouseDragOffsetX);
            int posY = (int)(pMouseY - (double)this.mouseDragOffsetY);
            this.updatePosition(posX, posY);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging && this.didDrag) {
            this.didDrag = false;
            this.dragging = false;
        } else if (super.m_5953_(mouseX, mouseY) && this.m_93412_(mouseX, mouseY) instanceof CategorySlot) {
            this.didDrag = false;
            this.dragging = false;
            super.m_6375_(mouseX, mouseY, mouseButton);
            CategorySlot slot = (CategorySlot)this.m_93412_(mouseX, mouseY);
            this.clicked = slot.isSelected();
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void updatePosition(int x, int y) {
        super.m_264152_(x, y);
        this.scrollbarX = this.f_93618_ - this.hpad + super.m_252754_();
        this.listWidth = this.f_93618_ - this.hpad * 4;
    }
}

